/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import javax.servlet.http.HttpServletResponse;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.addressbook.AddressBookFormData;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 個人アドレス登録/編集画面を処理するクラスです。 <br
 * 
 */
public class AddressBookFormScreen extends ALVelocityScreen {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(AddressBookFormScreen.class.getName());

  /**
   * 個人アドレス登録/編集画面表示処理
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   */
  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {

    try {
      doAddressBook_form(rundata, context);
    } catch (Exception ex) {
      // change start
      // logger.error("[AddressBookFormScreen] Exception.", ex);
      logger.error("個人アドレス登録/編集画面表示処理に失敗しました。", ex);
      // change end
      ALEipUtils.redirectDBError(rundata);
    }
  }

  /**
   * 個人アドレス登録/編集画面表示処理
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   */
  // change start
  // protected void doAddressBook_form(RunData rundata, Context context) {
  // AddressBookFormData formData = new AddressBookFormData();
  // formData.initField();
  // formData.doViewForm(this, rundata, context);
  //
  // formData.loadGroupList(rundata, context);
  // formData.loadCompanyList(rundata, context);
  // formData.loadGroups(rundata, context);
  //
  // String layout_template = "portlets/html/ja/ajax-addressbook-form.vm";
  // setTemplate(rundata, context, layout_template);
  // }
  protected void doAddressBook_form(RunData rundata, Context context) {

    String layout_template = null;
    AddressBookFormData formData = new AddressBookFormData();
    formData.initField();
    if (formData.loadGroupList(rundata, context)) {
      if (formData.doViewForm(this, rundata, context)) {
        layout_template = "portlets/html/ja/ajax-addressbook-form.vm";
      } else {
        layout_template = "portlets/html/ja/DBErrorForWindow.vm";
      }
    } else {
      layout_template = "portlets/html/ja/DBErrorForWindow.vm";
    }

    HttpServletResponse response = rundata.getResponse();
    response
      .setContentType("text/html; " + ALEipConstants.DEF_CONTENT_ENCODING);

    setTemplate(rundata, context, layout_template);
  }
  // change end
}
