/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.nhttp;

import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPTransportUtils;

public class Util {
    public static EndpointReference getDestinationEPR(MessageContext msgContext) {
        String transportURL = (String)msgContext.getProperty("TransportURL");
        if (transportURL != null) {
            return new EndpointReference(transportURL);
        }
        if (msgContext.getTo() != null && !"http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous".equals(msgContext.getTo().getAddress()) && !"http://www.w3.org/2005/08/addressing/anonymous".equals(msgContext.getTo().getAddress())) {
            return msgContext.getTo();
        }
        return null;
    }

    public static OMOutputFormat getOMOutputFormat(MessageContext msgContext) {
        OMOutputFormat format = new OMOutputFormat();
        msgContext.setDoingMTOM(HTTPTransportUtils.doWriteMTOM(msgContext));
        msgContext.setDoingSwA(HTTPTransportUtils.doWriteSwA(msgContext));
        msgContext.setDoingREST(HTTPTransportUtils.isDoingREST(msgContext));
        format.setSOAP11(msgContext.isSOAP11());
        format.setDoOptimize(msgContext.isDoingMTOM());
        format.setDoingSWA(msgContext.isDoingSwA());
        format.setCharSetEncoding(HTTPTransportUtils.getCharSetEncoding(msgContext));
        Object mimeBoundaryProperty = msgContext.getProperty("mimeBoundary");
        if (mimeBoundaryProperty != null) {
            format.setMimeBoundary((String)mimeBoundaryProperty);
        }
        return format;
    }

    public static String getContentType(MessageContext msgContext) {
        Object contentTypeObject = msgContext.getProperty("ContentType");
        if (contentTypeObject != null) {
            return (String)contentTypeObject;
        }
        if (msgContext.isDoingREST()) {
            return "application/xml";
        }
        return Util.getOMOutputFormat(msgContext).getContentType();
    }
}

