/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.nhttp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.http.HTTPTransportReceiver;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.nhttp.HttpCoreRequestResponseTransport;
import org.apache.axis2.transport.nhttp.ServerHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.ws.commons.schema.XmlSchema;

public class ServerWorker
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)ServerWorker.class);
    private MessageContext msgContext = null;
    private ConfigurationContext cfgCtx = null;
    private ServerHandler serverHandler = null;
    private NHttpServerConnection conn = null;
    private boolean isHttps = false;
    private HttpRequest request = null;
    private HttpResponse response = null;
    private InputStream is = null;
    private OutputStream os = null;
    private static final String SOAPACTION = "SOAPAction";
    private static final String LOCATION = "Location";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String TEXT_HTML = "text/html";
    private static final String TEXT_XML = "text/xml";

    public ServerWorker(ConfigurationContext cfgCtx, NHttpServerConnection conn, boolean isHttps, ServerHandler serverHandler, HttpRequest request, InputStream is, HttpResponse response, OutputStream os) {
        this.cfgCtx = cfgCtx;
        this.conn = conn;
        this.isHttps = isHttps;
        this.serverHandler = serverHandler;
        this.request = request;
        this.response = response;
        this.is = is;
        this.os = os;
        this.msgContext = this.createMessageContext(request);
    }

    private MessageContext createMessageContext(HttpRequest request) {
        HttpInetConnection inetConn;
        InetAddress remoteAddr;
        MessageContext msgContext = new MessageContext();
        msgContext.setProperty("transportNonBlocking", Boolean.TRUE);
        msgContext.setConfigurationContext(this.cfgCtx);
        if (this.isHttps) {
            msgContext.setTransportOut(this.cfgCtx.getAxisConfiguration().getTransportOut("https"));
            msgContext.setTransportIn(this.cfgCtx.getAxisConfiguration().getTransportIn("https"));
            msgContext.setIncomingTransportName("https");
        } else {
            msgContext.setTransportOut(this.cfgCtx.getAxisConfiguration().getTransportOut("http"));
            msgContext.setTransportIn(this.cfgCtx.getAxisConfiguration().getTransportIn("http"));
            msgContext.setIncomingTransportName("http");
        }
        msgContext.setProperty("OutTransportInfo", this);
        msgContext.setServiceGroupContextId(UUIDGenerator.getUUID());
        msgContext.setServerSide(true);
        msgContext.setProperty("TransportInURL", request.getRequestLine().getUri());
        HashMap<String, String> headers = new HashMap<String, String>();
        Header[] headerArr = request.getAllHeaders();
        for (int i = 0; i < headerArr.length; ++i) {
            headers.put(headerArr[i].getName(), headerArr[i].getValue());
        }
        msgContext.setProperty("TRANSPORT_HEADERS", headers);
        if (this.conn instanceof HttpInetConnection && (remoteAddr = (inetConn = (HttpInetConnection)this.conn).getRemoteAddress()) != null) {
            msgContext.setProperty("REMOTE_ADDR", remoteAddr.getHostAddress());
        }
        msgContext.setProperty("RequestResponseTransportControl", new HttpCoreRequestResponseTransport(msgContext));
        return msgContext;
    }

    public void run() {
        String method = this.request.getRequestLine().getMethod().toUpperCase();
        if ("GET".equals(method)) {
            this.processGet();
        } else if ("POST".equals(method)) {
            this.processPost();
        } else {
            this.handleException("Unsupported method : " + method, null);
        }
        if (this.msgContext != null && this.msgContext.getOperationContext() != null && !"true".equals(this.msgContext.getOperationContext().getProperty("RESPONSE_WRITTEN")) && !"SKIP".equals(this.msgContext.getOperationContext().getProperty("RESPONSE_WRITTEN"))) {
            this.response.setStatusCode(202);
            this.serverHandler.commitResponse(this.conn, this.response);
            try {
                this.is.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            try {
                this.os.flush();
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void processPost() {
        try {
            Header contentType = this.request.getFirstHeader(CONTENT_TYPE);
            Header soapAction = this.request.getFirstHeader(SOAPACTION);
            HTTPTransportUtils.processHTTPPostRequest(this.msgContext, this.is, this.os, contentType != null ? contentType.getValue() : null, soapAction != null ? soapAction.getValue() : null, this.request.getRequestLine().getUri());
        }
        catch (AxisFault e) {
            this.handleException("Error processing POST request ", e);
        }
    }

    private void processGet() {
        AxisService service;
        String servicePath;
        String uri = this.request.getRequestLine().getUri();
        String contextPath = this.cfgCtx.getContextRoot();
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        if (!contextPath.endsWith("/")) {
            contextPath = contextPath + "/";
        }
        if (!(servicePath = this.cfgCtx.getServiceContextPath()).startsWith("/")) {
            servicePath = "/" + servicePath;
        }
        String serviceName = null;
        if (uri.startsWith(servicePath)) {
            serviceName = uri.substring(servicePath.length());
            if (serviceName.startsWith("/")) {
                serviceName = serviceName.substring(1);
            }
            if (serviceName.indexOf("?") != -1) {
                serviceName = serviceName.substring(0, serviceName.indexOf("?"));
            }
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        int pos = uri.indexOf("?");
        if (pos != -1) {
            StringTokenizer st = new StringTokenizer(uri.substring(pos + 1), "&");
            while (st.hasMoreTokens()) {
                String param = st.nextToken();
                pos = param.indexOf("=");
                if (pos != -1) {
                    parameters.put(param.substring(0, pos), param.substring(pos + 1));
                    continue;
                }
                parameters.put(param, null);
            }
        }
        if (uri.equals("/favicon.ico")) {
            this.response.setStatusCode(301);
            this.response.addHeader(LOCATION, "http://ws.apache.org/favicon.ico");
            this.serverHandler.commitResponse(this.conn, this.response);
        } else if (!uri.startsWith(servicePath)) {
            this.response.setStatusCode(301);
            this.response.addHeader(LOCATION, servicePath + "/");
            this.serverHandler.commitResponse(this.conn, this.response);
        } else if (serviceName != null && parameters.containsKey("wsdl")) {
            service = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
            if (service != null) {
                try {
                    this.response.addHeader(CONTENT_TYPE, TEXT_XML);
                    this.serverHandler.commitResponse(this.conn, this.response);
                    service.printWSDL(this.os, ServerWorker.getIpAddress());
                }
                catch (AxisFault e) {
                    this.handleException("Axis2 fault writing ?wsdl output", e);
                    return;
                }
                catch (SocketException e) {
                    this.handleException("Error getting ip address for ?wsdl output", e);
                    return;
                }
            }
        } else if (serviceName != null && parameters.containsKey("wsdl2")) {
            service = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
            if (service != null) {
                try {
                    this.response.addHeader(CONTENT_TYPE, TEXT_XML);
                    this.serverHandler.commitResponse(this.conn, this.response);
                    service.printWSDL2(this.os, ServerWorker.getIpAddress());
                }
                catch (AxisFault e) {
                    this.handleException("Axis2 fault writing ?wsdl2 output", e);
                    return;
                }
                catch (SocketException e) {
                    this.handleException("Axis2 fault writing ?wsdl2 output", e);
                    return;
                }
            }
        } else if (serviceName != null && parameters.containsKey("xsd")) {
            if (parameters.get("xsd") == null || "".equals(parameters.get("xsd"))) {
                service = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
                if (service != null) {
                    try {
                        this.response.addHeader(CONTENT_TYPE, TEXT_XML);
                        this.serverHandler.commitResponse(this.conn, this.response);
                        service.printSchema(this.os);
                    }
                    catch (AxisFault axisFault) {
                        this.handleException("Error writing ?xsd output to client", axisFault);
                        return;
                    }
                }
            } else {
                String schemaName = (String)parameters.get("xsd");
                AxisService service2 = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
                if (service2 != null) {
                    int dotIndex;
                    service2.populateSchemaMappings();
                    Map schemaTable = service2.getSchemaMappingTable();
                    XmlSchema schema = (XmlSchema)schemaTable.get(schemaName);
                    if (schema == null && (dotIndex = schemaName.indexOf(46)) > 0) {
                        String schemaKey = schemaName.substring(0, dotIndex);
                        schema = (XmlSchema)schemaTable.get(schemaKey);
                    }
                    if (schema != null) {
                        this.response.addHeader(CONTENT_TYPE, TEXT_XML);
                        this.serverHandler.commitResponse(this.conn, this.response);
                        schema.write(this.os);
                    } else {
                        this.response.setStatusCode(404);
                    }
                }
            }
        } else if (serviceName == null || serviceName.length() == 0) {
            try {
                this.response.addHeader(CONTENT_TYPE, TEXT_HTML);
                this.serverHandler.commitResponse(this.conn, this.response);
                this.os.write(HTTPTransportReceiver.getServicesHTML(this.cfgCtx).getBytes());
            }
            catch (IOException e) {
                this.handleException("Error writing ? output to client", e);
            }
        } else {
            if (parameters.isEmpty()) {
                service = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
                if (service != null) {
                    try {
                        this.response.addHeader(CONTENT_TYPE, TEXT_HTML);
                        this.serverHandler.commitResponse(this.conn, this.response);
                        this.os.write(HTTPTransportReceiver.printServiceHTML(serviceName, this.cfgCtx).getBytes());
                    }
                    catch (IOException e) {
                        this.handleException("Error writing service HTML to client", e);
                        return;
                    }
                }
                this.handleException("Invalid service : " + serviceName, null);
                return;
            }
            try {
                this.serverHandler.commitResponse(this.conn, this.response);
                HTTPTransportUtils.processHTTPGetRequest(this.msgContext, this.os, this.request.getFirstHeader(SOAPACTION) != null ? this.request.getFirstHeader(SOAPACTION).getValue() : null, this.request.getRequestLine().getUri(), this.cfgCtx, parameters);
            }
            catch (AxisFault axisFault) {
                this.handleException("Error processing GET request for: " + this.request.getRequestLine().getUri(), axisFault);
            }
        }
        try {
            this.os.flush();
            this.os.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    private void handleException(String msg, Exception e) {
        block10: {
            if (e == null) {
                log.error((Object)msg);
            } else {
                log.error((Object)msg, (Throwable)e);
            }
            if (e == null) {
                e = new Exception(msg);
            }
            try {
                AxisEngine engine = new AxisEngine(this.cfgCtx);
                MessageContext faultContext = AxisEngine.createFaultMessageContext(this.msgContext, e);
                AxisEngine.sendFault(faultContext);
            }
            catch (Exception ex) {
                this.response.setStatusCode(500);
                this.response.addHeader(CONTENT_TYPE, TEXT_XML);
                this.serverHandler.commitResponse(this.conn, this.response);
                try {
                    String msg2;
                    this.os.write(msg.getBytes());
                    if (ex != null && (msg2 = ex.getMessage()) != null) {
                        this.os.write(msg2.getBytes());
                    }
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                if (this.conn == null) break block10;
                try {
                    this.conn.shutdown();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
        }
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public InputStream getIs() {
        return this.is;
    }

    public ServerHandler getServiceHandler() {
        return this.serverHandler;
    }

    public NHttpServerConnection getConn() {
        return this.conn;
    }

    private static String getIpAddress() throws SocketException {
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        String address = "127.0.0.1";
        while (e.hasMoreElements()) {
            NetworkInterface netface = e.nextElement();
            Enumeration<InetAddress> addresses = netface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress ip = addresses.nextElement();
                if (ip.isLoopbackAddress() || !ServerWorker.isIP(ip.getHostAddress())) continue;
                return ip.getHostAddress();
            }
        }
        return address;
    }

    private static boolean isIP(String hostAddress) {
        return hostAddress.split("[.]").length == 4;
    }
}

