/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.i18n.Messages;

public class InOnlyAxisOperation
extends AxisOperation {
    private AxisMessage inFaultMessage;
    private AxisMessage outFaultMessage;
    private ArrayList outPhase;

    public InOnlyAxisOperation() {
        QName tmpName = new QName(this.getClass().getName() + "_" + UUIDGenerator.getUUID());
        this.setName(tmpName);
        this.createMessage();
        this.setMessageExchangePattern("http://www.w3.org/ns/wsdl/in-only");
    }

    public InOnlyAxisOperation(QName name) {
        super(name);
        this.createMessage();
        this.setMessageExchangePattern("http://www.w3.org/ns/wsdl/in-only");
    }

    public void addMessage(AxisMessage message, String label) {
        if (!"In".equals(label)) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        this.addChild("inMessage", message);
    }

    public void addMessageContext(MessageContext msgContext, OperationContext opContext) throws AxisFault {
        if (opContext.isComplete()) {
            throw new AxisFault(Messages.getMessage("mepcompleted"));
        }
        opContext.getMessageContexts().put("In", msgContext);
        opContext.setComplete(true);
    }

    public void addFaultMessageContext(MessageContext msgContext, OperationContext opContext) throws AxisFault {
        HashMap mep = opContext.getMessageContexts();
        MessageContext faultMessageCtxt = (MessageContext)mep.get("Fault");
        if (faultMessageCtxt != null) {
            throw new AxisFault(Messages.getMessage("mepcompleted"));
        }
        mep.put("Fault", msgContext);
        opContext.setComplete(true);
        opContext.cleanup();
    }

    private void createMessage() {
        AxisMessage inMessage = new AxisMessage();
        inMessage.setDirection("in");
        inMessage.setParent(this);
        this.inFaultMessage = new AxisMessage();
        this.inFaultMessage.setParent(this);
        this.outFaultMessage = new AxisMessage();
        this.outFaultMessage.setParent(this);
        this.outPhase = new ArrayList();
        this.addChild("inMessage", inMessage);
    }

    public AxisMessage getMessage(String label) {
        if ("In".equals(label)) {
            return (AxisMessage)this.getChild("inMessage");
        }
        throw new UnsupportedOperationException(Messages.getMessage("invalidacess"));
    }

    public ArrayList getPhasesInFaultFlow() {
        return this.inFaultMessage.getMessageFlow();
    }

    public ArrayList getPhasesOutFaultFlow() {
        return this.outFaultMessage.getMessageFlow();
    }

    public ArrayList getPhasesOutFlow() {
        return this.outPhase;
    }

    public ArrayList getRemainingPhasesInFlow() {
        return ((AxisMessage)this.getChild("inMessage")).getMessageFlow();
    }

    public void setPhasesInFaultFlow(ArrayList list) {
        this.inFaultMessage.setMessageFlow(list);
    }

    public void setPhasesOutFaultFlow(ArrayList list) {
        this.outFaultMessage.setMessageFlow(list);
    }

    public void setPhasesOutFlow(ArrayList list) {
        this.outPhase = list;
    }

    public void setRemainingPhasesInFlow(ArrayList list) {
        ((AxisMessage)this.getChild("inMessage")).setMessageFlow(list);
    }
}

