/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server;

import javax.xml.ws.Binding;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.InvocationContextFactory;
import org.apache.axis2.jaxws.handler.AttachmentsAdapter;
import org.apache.axis2.jaxws.handler.MEPContext;
import org.apache.axis2.jaxws.handler.SOAPHeadersAdapter;
import org.apache.axis2.jaxws.handler.TransportHeadersAdapter;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.util.MessageUtils;
import org.apache.axis2.jaxws.registry.InvocationListenerRegistry;
import org.apache.axis2.jaxws.server.EndpointCallback;
import org.apache.axis2.jaxws.server.EndpointController;
import org.apache.axis2.jaxws.server.EndpointInvocationContext;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.ThreadContextMigratorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXWSMessageReceiver
implements MessageReceiver {
    private static final Log log = LogFactory.getLog(JAXWSMessageReceiver.class);
    private static String PARAM_SERVICE_CLASS = "ServiceClass";
    public static String PARAM_BINDING = "Binding";

    public void receive(MessageContext axisRequestMsgCtx) throws AxisFault {
        AxisService service;
        Parameter svcClassParam;
        AxisFault faultToReturn = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"new request received");
        }
        if ((svcClassParam = (service = axisRequestMsgCtx.getAxisService()).getParameter(PARAM_SERVICE_CLASS)) == null) {
            throw new RuntimeException(Messages.getMessage((String)"JAXWSMessageReceiverNoServiceClass"));
        }
        Parameter endpointDescParam = service.getParameter("org.apache.axis2.jaxws.description.EndpointDescription");
        if (endpointDescParam == null) {
            throw new RuntimeException(Messages.getMessage((String)"JAXWSMessageReceiverNoServiceClass"));
        }
        AxisOperation operation = axisRequestMsgCtx.getAxisOperation();
        String mep = operation.getMessageExchangePattern();
        if (log.isDebugEnabled()) {
            log.debug((Object)("MEP: " + mep));
        }
        try {
            ThreadContextMigratorUtil.performMigrationToThread((String)"JAXWS-ThreadContextMigrator-List", (MessageContext)axisRequestMsgCtx);
            EndpointController endpointCtlr = new EndpointController();
            org.apache.axis2.jaxws.core.MessageContext requestMsgCtx = new org.apache.axis2.jaxws.core.MessageContext(axisRequestMsgCtx);
            requestMsgCtx.setServer(true);
            requestMsgCtx.setMEPContext(new MEPContext(requestMsgCtx));
            ClassLoader loader = this.getCachedClassLoader(axisRequestMsgCtx);
            if (loader != null) {
                requestMsgCtx.setProperty("CACHE_CLASSLOADER", loader);
            }
            AttachmentsAdapter.install(requestMsgCtx);
            TransportHeadersAdapter.install(requestMsgCtx);
            SOAPHeadersAdapter.install(requestMsgCtx);
            Binding binding = (Binding)axisRequestMsgCtx.getProperty(PARAM_BINDING);
            EndpointInvocationContext eic = InvocationContextFactory.createEndpointInvocationContext(binding);
            this.addInvocationListenerFactories(eic);
            eic.setRequestMessageContext(requestMsgCtx);
            eic.getRequestMessageContext().setProperty("serverDisableThreadSwitch", true);
            if (this.isMepInOnly(mep)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Detected a one way invocation.");
                }
                eic.setIsOneWay(true);
                endpointCtlr.invokeOneWay(eic);
            } else if (JavaUtils.isTrueExplicitly((Object)axisRequestMsgCtx.getProperty("IsAddressingProcessed")) && axisRequestMsgCtx.getReplyTo() != null && !axisRequestMsgCtx.getReplyTo().hasAnonymousAddress()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Detected an async invocation.");
                }
                EndpointCallback ecb = new EndpointCallback();
                eic.setCallback(ecb);
                endpointCtlr.invokeAsync(eic);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Detected a sync invocation.");
                }
                eic = endpointCtlr.invoke(eic);
                org.apache.axis2.jaxws.core.MessageContext responseMsgCtx = eic.getResponseMessageContext();
                MessageContext axisResponseMsgCtx = responseMsgCtx.getAxisMessageContext();
                if (loader != null) {
                    responseMsgCtx.setProperty("CACHE_CLASSLOADER", loader);
                }
                MessageUtils.putMessageOnMessageContext(responseMsgCtx.getMessage(), axisResponseMsgCtx);
                OperationContext opCtx = axisResponseMsgCtx.getOperationContext();
                opCtx.addMessageContext(axisResponseMsgCtx);
                if (responseMsgCtx.getMessage().isFault()) {
                    faultToReturn = responseMsgCtx.getCausedByException() != null ? responseMsgCtx.getCausedByException() : new AxisFault("An error was detected during JAXWS processing", axisResponseMsgCtx);
                } else {
                    ThreadContextMigratorUtil.performMigrationToContext((String)"JAXWS-ThreadContextMigrator-List", (MessageContext)axisResponseMsgCtx);
                    AxisEngine engine = new AxisEngine(axisResponseMsgCtx.getConfigurationContext());
                    AxisEngine.send((MessageContext)axisResponseMsgCtx);
                    ThreadContextMigratorUtil.performContextCleanup((String)"JAXWS-ThreadContextMigrator-List", (MessageContext)axisResponseMsgCtx);
                }
            }
        }
        catch (AxisFault af) {
            throw af;
        }
        catch (Exception e) {
            ThreadContextMigratorUtil.performThreadCleanup((String)"JAXWS-ThreadContextMigrator-List", (MessageContext)axisRequestMsgCtx);
            WebServiceException wse = ExceptionFactory.makeWebServiceException((Throwable)e);
            throw AxisFault.makeFault((Throwable)wse);
        }
        ThreadContextMigratorUtil.performThreadCleanup((String)"JAXWS-ThreadContextMigrator-List", (MessageContext)axisRequestMsgCtx);
        if (faultToReturn != null) {
            throw faultToReturn;
        }
    }

    private boolean isMepInOnly(String mep) {
        boolean inOnly = mep.equals("http://www.w3.org/2004/08/wsdl/robust-in-only") || mep.equals("http://www.w3.org/2004/08/wsdl/in-only") || mep.equals("http://www.w3.org/ns/wsdl/in-only") || mep.equals("http://www.w3.org/ns/wsdl/robust-in-only") || mep.equals("http://www.w3.org/2006/01/wsdl/robust-in-only") || mep.equals("http://www.w3.org/2006/01/wsdl/in-only");
        return inOnly;
    }

    void addInvocationListenerFactories(EndpointInvocationContext eic) {
        eic.setInvocationListenerFactories(InvocationListenerRegistry.getFactories());
    }

    public ClassLoader getCachedClassLoader(MessageContext msgContext) {
        return (ClassLoader)msgContext.getAxisService().getParameterValue("CACHE_CLASSLOADER");
    }
}

