/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.util.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.util.SAAJConverter;
import org.apache.axis2.jaxws.message.util.SOAPElementReader;
import org.apache.axis2.jaxws.utility.SAAJFactory;
import org.apache.axis2.saaj.SOAPElementImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class SAAJConverterImpl
implements SAAJConverter {
    private static final Log log = LogFactory.getLog(SAAJConverterImpl.class);

    SAAJConverterImpl() {
    }

    public SOAPEnvelope toSAAJ(org.apache.axiom.soap.SOAPEnvelope omEnvelope) throws WebServiceException {
        SOAPEnvelope soapEnvelope = null;
        try {
            SOAPHeader soapHeader;
            OMNamespace ns = omEnvelope.getNamespace();
            MessageFactory mf = this.createMessageFactory(ns.getNamespaceURI());
            SOAPMessage sm = mf.createMessage();
            SOAPPart sp = sm.getSOAPPart();
            soapEnvelope = sp.getEnvelope();
            SOAPBody soapBody = soapEnvelope.getBody();
            if (soapBody != null) {
                soapBody.detachNode();
            }
            if ((soapHeader = soapEnvelope.getHeader()) != null) {
                soapHeader.detachNode();
            }
            XMLStreamReader reader = omEnvelope.getXMLStreamReader();
            NameCreator nc = new NameCreator(soapEnvelope);
            this.buildSOAPTree(nc, (SOAPElement)soapEnvelope, null, reader, false);
        }
        catch (WebServiceException e) {
            throw e;
        }
        catch (SOAPException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        return soapEnvelope;
    }

    public org.apache.axiom.soap.SOAPEnvelope toOM(SOAPEnvelope saajEnvelope) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Converting SAAJ SOAPEnvelope to an OM SOAPEnvelope");
        }
        this._fixFaultElements(saajEnvelope);
        SOAPElementReader reader = new SOAPElementReader((SOAPElement)saajEnvelope);
        StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder((XMLStreamReader)reader, null);
        org.apache.axiom.soap.SOAPEnvelope omEnvelope = builder.getSOAPEnvelope();
        try {
            omEnvelope.build();
        }
        catch (OMException ex) {
            try {
                return this.toOM(this.toString(saajEnvelope));
            }
            catch (TransformerException e) {
                throw ExceptionFactory.makeWebServiceException((Throwable)e);
            }
        }
        return omEnvelope;
    }

    private org.apache.axiom.soap.SOAPEnvelope toOM(String xml) throws WebServiceException {
        XMLStreamReader reader;
        try {
            reader = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(xml.getBytes()));
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(reader, null);
        return builder.getSOAPEnvelope();
    }

    private String toString(SOAPEnvelope saajEnvelope) throws TransformerException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Transformer tf = TransformerFactory.newInstance().newTransformer();
        tf.transform(new DOMSource(saajEnvelope.getOwnerDocument()), new StreamResult(baos));
        return new String(baos.toByteArray());
    }

    public OMElement toOM(SOAPElement soapElement) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Converting SAAJ SOAPElement to an OMElement");
        }
        SOAPElementReader reader = new SOAPElementReader(soapElement);
        StAXOMBuilder builder = new StAXOMBuilder((XMLStreamReader)reader);
        OMElement om = builder.getDocumentElement();
        om.build();
        return om;
    }

    public SOAPElement toSAAJ(OMElement omElement, SOAPElement parent) throws WebServiceException {
        SOAPElement env;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Converting OMElement to an SAAJ SOAPElement");
        }
        XMLStreamReader reader = null;
        reader = omElement.getBuilder() == null ? omElement.getXMLStreamReader() : omElement.getXMLStreamReaderWithoutCaching();
        for (env = parent; env != null && !(env instanceof SOAPEnvelope); env = env.getParentElement()) {
        }
        if (env == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SAAJConverterErr1"));
        }
        NameCreator nc = new NameCreator((SOAPEnvelope)env);
        return this.buildSOAPTree(nc, null, parent, reader, false);
    }

    public SOAPElement toSAAJ(OMElement omElement, SOAPElement parent, SOAPFactory sf) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Converting OMElement to an SAAJ SOAPElement");
        }
        XMLStreamReader reader = null;
        reader = omElement.getBuilder() == null ? omElement.getXMLStreamReader() : omElement.getXMLStreamReaderWithoutCaching();
        NameCreator nc = new NameCreator(sf);
        return this.buildSOAPTree(nc, null, parent, reader, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SOAPElement buildSOAPTree(NameCreator nc, SOAPElement root, SOAPElement parent, XMLStreamReader reader, boolean quitAtBody) throws WebServiceException {
        try {
            block19: while (reader.hasNext()) {
                int eventID = reader.next();
                switch (eventID) {
                    case 1: {
                        if (parent == null) {
                            this.updateTagData(nc, root, reader, false);
                            parent = root;
                        } else {
                            parent = this.createElementFromTag(nc, parent, reader);
                            if (root == null) {
                                root = parent;
                            }
                        }
                        if (!quitAtBody || !(parent instanceof SOAPBody)) continue block19;
                        return root;
                    }
                    case 10: {
                        String eventName = "ATTRIBUTE";
                        this._unexpectedEvent(eventName);
                        continue block19;
                    }
                    case 13: {
                        String eventName = "NAMESPACE";
                        this._unexpectedEvent(eventName);
                        continue block19;
                    }
                    case 2: {
                        if (parent instanceof SOAPEnvelope) {
                            parent = null;
                            continue block19;
                        }
                        parent = parent.getParentElement();
                        continue block19;
                    }
                    case 4: {
                        parent.addTextNode(reader.getText());
                        continue block19;
                    }
                    case 12: {
                        parent.addTextNode(reader.getText());
                        continue block19;
                    }
                    case 5: {
                        parent.addTextNode("<!--" + reader.getText() + "-->");
                        continue block19;
                    }
                    case 6: {
                        parent.addTextNode(reader.getText());
                        continue block19;
                    }
                    case 7: {
                        continue block19;
                    }
                    case 8: {
                        reader.close();
                        continue block19;
                    }
                    case 3: {
                        continue block19;
                    }
                    case 9: {
                        continue block19;
                    }
                    case 11: {
                        continue block19;
                    }
                }
                this._unexpectedEvent("EventID " + String.valueOf(eventID));
            }
            return root;
        }
        catch (WebServiceException e) {
            throw e;
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        catch (SOAPException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    protected SOAPElement createElementFromTag(NameCreator nc, SOAPElement parent, XMLStreamReader reader) throws SOAPException {
        QName qName = reader.getName();
        SOAPElement child = this.createElement(parent, qName);
        this.updateTagData(nc, child, reader, true);
        return child;
    }

    protected SOAPElement createElement(SOAPElement parent, QName qName) throws SOAPException {
        Object child = parent instanceof SOAPEnvelope ? (qName.getNamespaceURI().equals(parent.getNamespaceURI()) ? (qName.getLocalPart().equals("Body") ? ((SOAPEnvelope)parent).addBody() : ((SOAPEnvelope)parent).addHeader()) : parent.addChildElement(qName)) : (parent instanceof SOAPBody ? (qName.getNamespaceURI().equals(parent.getNamespaceURI()) && qName.getLocalPart().equals("Fault") ? ((SOAPBody)parent).addFault() : ((SOAPBody)parent).addBodyElement(qName)) : (parent instanceof SOAPHeader ? ((SOAPHeader)parent).addHeaderElement(qName) : (parent instanceof SOAPFault ? parent.addChildElement(qName) : (parent instanceof Detail ? ((Detail)parent).addDetailEntry(qName) : parent.addChildElement(qName)))));
        return child;
    }

    protected void updateTagData(NameCreator nc, SOAPElement element, XMLStreamReader reader, boolean newElement) throws SOAPException {
        String ns;
        String prefix = reader.getPrefix();
        String string = prefix = prefix == null ? "" : prefix;
        if (prefix.length() > 0 && !element.getPrefix().equals(prefix) && (ns = reader.getNamespaceURI()) != null && ns.length() != 0) {
            element.setPrefix(prefix);
        }
        if (!newElement) {
            int size = reader.getNamespaceCount();
            for (int i = 0; i < size; ++i) {
                String existingNS;
                String pre = reader.getNamespacePrefix(i);
                String ns2 = reader.getNamespaceURI(i);
                if (ns2.equals(existingNS = element.getNamespaceURI(pre))) continue;
                element.removeNamespaceDeclaration(pre);
                element.addNamespaceDeclaration(pre, ns2);
            }
        } else {
            int size = reader.getNamespaceCount();
            for (int i = 0; i < size; ++i) {
                element.addNamespaceDeclaration(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
            }
        }
        this.addAttributes(nc, element, reader);
    }

    protected void addAttributes(NameCreator nc, SOAPElement element, XMLStreamReader reader) throws SOAPException {
        int size = reader.getAttributeCount();
        for (int i = 0; i < size; ++i) {
            QName qName = reader.getAttributeName(i);
            String prefix = reader.getAttributePrefix(i);
            String value = reader.getAttributeValue(i);
            Name name = nc.createName(qName.getLocalPart(), prefix, qName.getNamespaceURI());
            element.addAttribute(name, value);
        }
    }

    private void _unexpectedEvent(String event) throws WebServiceException {
        throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SAAJConverterErr2", (String)event));
    }

    private void _fixFaultElements(SOAPEnvelope env) {
        try {
            if (env.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) {
                return;
            }
            SOAPBody body = env.getBody();
            if (body != null && !body.hasFault()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No fault found.  No conversion necessary.");
                }
                return;
            }
            if (body != null && body.hasFault()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"A fault was found.  Converting the fault child elements to SOAP 1.1 format");
                }
                SOAPFault fault = body.getFault();
                Iterator itr = fault.getChildElements();
                while (itr.hasNext()) {
                    SOAPElement child;
                    String content;
                    ElementImpl e;
                    SOAPElementImpl valueElement;
                    Node value;
                    SOAPElement se = (SOAPElement)itr.next();
                    if (se.getLocalName().equals("Code")) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Converting: faultcode");
                        }
                        if ((value = se.getFirstChild()) == null || !(value instanceof SOAPElementImpl)) continue;
                        valueElement = (SOAPElementImpl)value;
                        e = valueElement.getElement();
                        content = e.getText();
                        child = fault.addChildElement(new QName(se.getNamespaceURI(), "faultcode"));
                        child.addTextNode(content);
                        se.detachNode();
                        continue;
                    }
                    if (se.getLocalName().equals("Detail")) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Converting: detail");
                        }
                        se.setElementQName(new QName(se.getNamespaceURI(), "detail"));
                        continue;
                    }
                    if (!se.getLocalName().equals("Reason")) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Converting: faultstring");
                    }
                    se.setElementQName(new QName(se.getNamespaceURI(), "faultstring"));
                    value = se.getFirstChild();
                    if (value == null || !(value instanceof SOAPElementImpl)) continue;
                    valueElement = (SOAPElementImpl)value;
                    e = valueElement.getElement();
                    content = e.getText();
                    child = fault.addChildElement(new QName(se.getNamespaceURI(), "faultstring"));
                    child.addTextNode(content);
                    se.detachNode();
                }
            }
        }
        catch (SOAPException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("An error occured while converting fault elements: " + e.getMessage()));
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public MessageFactory createMessageFactory(String namespace) throws SOAPException, WebServiceException {
        return SAAJFactory.createMessageFactory(namespace);
    }

    protected class NameCreator {
        private SOAPEnvelope env = null;
        private SOAPFactory sf = null;

        public NameCreator(SOAPEnvelope env) {
            this.env = env;
        }

        public NameCreator(SOAPFactory sf) {
            this.sf = sf;
        }

        public Name createName(String localName, String prefix, String uri) throws SOAPException {
            if (this.sf != null) {
                return this.sf.createName(localName, prefix, uri);
            }
            return this.env.createName(localName, prefix, uri);
        }
    }
}

