package aipo.webservice.soap.axis2.bean;

/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/**
 * <HR>
 * メール表示情報格納用Bean
 * <p>
 * 
 * リマインダーに表示するメール表示情報の格納用Beanクラス
 * <P>
 * <HR>
 * <P>
 * 
 */
public class ReceiveMailViewBean {
  private String uId;

  private String receiveDate;

  private String receiveTime;

  private String subject;

  private String body;

  private boolean isSubstitute;

  /**
   * ユニークIDを取得します。
   * 
   * @return ユニークID
   */
  public String getuId() {
    return uId;
  }

  /**
   * ユニークIDを設定します。
   * 
   * @param uId
   *          セットするユニークID
   */
  public void setuId(String uId) {
    this.uId = uId;
  }

  /**
   * 受信日付を取得します。
   * 
   * @return 受信日付
   */
  public String getReceiveDate() {
    return receiveDate;
  }

  /**
   * 受信日付を設定します。
   * 
   * @param receiveDate
   *          セットする受信日付
   */
  public void setReceiveDate(String receiveDate) {
    this.receiveDate = receiveDate;
  }

  /**
   * 受信時刻を取得します。
   * 
   * @return 受信時刻
   */
  public String getReceiveTime() {
    return receiveTime;
  }

  /**
   * 受信時刻を設定します。
   * 
   * @param receiveTime
   *          セットする受信時刻
   */
  public void setReceiveTime(String receiveTime) {
    this.receiveTime = receiveTime;
  }

  /**
   * 件名を取得します。
   * 
   * @return 件名
   */
  public String getSubject() {
    return subject;
  }

  /**
   * 件名を設定します。
   * 
   * @param subject
   *          セットする件名
   */
  public void setSubject(String subject) {
    this.subject = subject;
  }

  /**
   * 本文を取得します。
   * 
   * @return 本文
   */
  public String getBody() {
    return body;
  }

  /**
   * 本文を設定します。
   * 
   * @param body
   *          セットする本文
   */
  public void setBody(String body) {
    this.body = body;
  }

  /**
   * 代理フラグを取得します。
   * 
   * @return isSubstitute
   */
  public boolean getIsSubstitute() {
    return isSubstitute;
  }

  /**
   * 代理フラグを設定します。
   * 
   * @param isSubstitute
   *          セットする 代理フラグ
   */
  public void setIsSubstitute(boolean isSubstitute) {
    this.isSubstitute = isSubstitute;
  }

}
