/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package aipo.batch.exec;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

import aipo.batch.mailaccount.ExportMailAccount;

/**
 * <HR>
 * メールアカウント移行バッチ実行クラス
 * <p>
 * 
 * メールアカウント移行バッチ処理を実行します。
 * <P>
 * <HR>
 * <P>
 * 
 */
public class MailAccountListExportBatchExecuter {

  /** ロガー */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService
      .getLogger(MailAccountListExportBatchExecuter.class.getName());

  /**
   * メールアカウント移行バッチ実行
   * <p>
   * メールアカウントリスト作成処理を呼び出す。<br>
   * 
   */
  public void executeMailAccountListExportBatch() {
    try {
      boolean result = false;

      logger.info("メールアカウント移行処理開始");

      // メールアカウントリスト作成処理を実行
      ExportMailAccount export = new ExportMailAccount();
      result = export.exportMailAccount();
      if (!result) {
        logger.error("メールアカウント移行処理でエラーが発生しました。");
        return;
      }

      logger.info("メールアカウント移行処理終了");

    } catch (Exception e) {
      logger.error("メールアカウント移行処理でエラーが発生しました。", e);
    }
  }
}
