/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import javax.servlet.http.HttpServletResponse;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.WebMailSelectData;
import com.aimluck.eip.webmail.WebMailSendSelectData;
import com.aimluck.eip.webmail.util.WebMailUtils;

/**
 * Webメールの詳細画面を処理するクラスです。 <br />
 * 
 */
public class WebMailDetailScreen extends ALVelocityScreen {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(WebMailDetailScreen.class.getName());

  /**
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {
    try {

      // add start
      String tab = rundata.getParameters().getString("tab");
      if (null == tab || tab.equals("")) {
        tab = ALEipUtils.getTemp(rundata, context, "tab");
      }
      // add end

      // change start
      // 受信の場合
      if (WebMailUtils.TAB_RECEIVE.equals(tab)) {

        WebMailSelectData detailData = new WebMailSelectData();
        detailData.initField();
        detailData.doViewDetail(this, rundata, context);

      } else {
        // 送信の場合
        WebMailSendSelectData detailData = new WebMailSendSelectData();
        detailData.initField();
        detailData.doViewDetail(this, rundata, context);
      }
      // change end

      String mailIndex =
        rundata.getParameters().getString(ALEipConstants.ENTITY_ID);
      context.put(WebMailUtils.ACCOUNT_ID, ALEipUtils.getTemp(
        rundata,
        context,
        WebMailUtils.ACCOUNT_ID));
      context.put("currentTab", ALEipUtils.getTemp(rundata, context, "tab"));
      context.put(ALEipConstants.ENTITY_ID, mailIndex);

      // add by motegi start
      HttpServletResponse response = rundata.getResponse();
      response.setContentType("text/html; "
        + ALEipConstants.DEF_CONTENT_ENCODING);
      // add end

      setTemplate(rundata, context, "portlets/html/ja/ajax-webmail-detail.vm");
    } catch (Exception ex) {
      logger.error("[WebMailDetailScreen] Exception.", ex);
      ALEipUtils.redirectDBError(rundata);
    }
  }
}
