/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 *
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.schedule.data;

import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.schedule.ScheduleConst;

/**
 * スケジュール参加メンバーのユーザー情報
 */
public class ScheduleMemberUser extends ALEipUser {

  /** スケジュールID */
  private Integer scheduleId = 0;

  /** 状態 */
  private String status = "";

  /** 参加必須フラグ */
  private String required = "";

  /** 重要フラグ */
  private String priority = "";

  /** ダミー未回答フラグ */
  private String dummyNonResponse = "";

  // add start 要件No.26 スケジュール個別色換え
  /** 個別色（色コード） */
  private String individualColor;

  // add end

  /**
   * 参加対象スケジュールのスケジュールIDを設定します。
   * 
   * @param value
   *          スケジュールID
   */
  public void setScheduleId(Integer value) {
    scheduleId = value;
  }

  /**
   * 参加対象スケジュールのスケジュールIDを返します。
   * 
   * @return スケジュールID
   */
  public Integer getScheduleId() {
    return scheduleId;
  }

  /**
   * 状態を設定します。
   * 
   * @param value
   *          状態
   */
  public void setStatus(String value) {
    status = value;
  }

  /**
   * 状態を返します。
   * 
   * @return 状態
   */
  public String getStatus() {
    return status;
  }

  /**
   * 状態が所有者か判定します。
   * 
   * @return 所有者の場合true、そうでない場合false。
   */
  public boolean isOwner() {
    return ScheduleConst.SCHEDULEMAP_STATUS_OWNER.equals(status);
  }

  /**
   * 状態が未回答か判定します。
   * 
   * @return 未回答の場合true、そうでない場合false。
   */
  public boolean isNonResponce() {
    return ScheduleConst.SCHEDULEMAP_STATUS_NON_RES.equals(status);
  }

  /**
   * 状態が承諾か判定します。
   * 
   * @return 承諾の場合true、そうでない場合false。
   */
  public boolean isConsent() {
    return ScheduleConst.SCHEDULEMAP_STATUS_CONSENT.equals(status);
  }

  /**
   * 状態が仮承諾か判定します。
   * 
   * @return 仮承諾の場合true、そうでない場合false。
   */
  public boolean isProvisional() {
    return ScheduleConst.SCHEDULEMAP_STATUS_PROVISIONAL.equals(status);
  }

  /**
   * 状態が削除（辞退して削除）か判定します。
   * 
   * @return 削除（辞退して削除）の場合true、そうでない場合false。
   */
  public boolean isRemove() {
    return ScheduleConst.SCHEDULEMAP_STATUS_REMOVE.equals(status);
  }

  /**
   * 状態が辞退か判定します。
   * 
   * @return 辞退の場合true、そうでない場合false。
   */
  public boolean isVeto() {
    return ScheduleConst.SCHEDULEMAP_STATUS_VETO.equals(status);
  }

  /**
   * 状態がダミースケジュールか判定します。
   * 
   * @return ダミースケジュールの場合true、そうでない場合false。
   */
  public boolean isDummy() {
    return ScheduleConst.SCHEDULEMAP_STATUS_DUMMY.equals(status);
  }

  /**
   * 必須フラグを設定します。
   * 
   * @param value
   *          必須フラグ
   */
  public void setRequired(String value) {
    required = value;
  }

  /**
   * 必須フラグを取得します。
   * 
   * @return 必須フラグ
   */
  public String getRequired() {
    return required;
  }

  /**
   * 参加必須メンバーか判定します。
   * 
   * @return 参加必須メンバーの場合true、参加任意メンバーの場合false。
   */
  public boolean isRequired() {
    return ScheduleConst.SCHEDULEMAP_REQUIRED_T.equals(required);
  }

  /**
   * 重要フラグを設定します。
   * 
   * @param value
   *          重要フラグ
   */
  public void setPriority(String value) {
    priority = value;
  }

  /**
   * 重要フラグを取得します。
   * 
   * @return 重要フラグ
   */
  public String getPriority() {
    return priority;
  }

  /**
   * 重要スケジュールか判定します。
   * 
   * @return 重要スケジュールの場合true、そうでない場合false。
   */
  public boolean hasPriority() {
    return ScheduleConst.SCHEDULEMAP_PRIORITY_T.equals(priority);
  }

  /**
   * ダミー未回答フラグを設定します。
   * 
   * @param value
   *          ダミー未回答フラグ
   */
  public void setDummyNonResponse(String value) {
    dummyNonResponse = value;
  }

  /**
   * ダミー未回答を取得します。
   * 
   * @return ダミー未回答フラグ
   */
  public String getDummyNonResponse() {
    return dummyNonResponse;
  }

  /**
   * ダミー未回答か判定します。
   * 
   * @return ダミー未回答の場合true、そうでない場合false。
   */
  public boolean isDummyNonResponse() {
    return ScheduleConst.SCHEDULEMAP_DUMMY_NON_RES_T.equals(dummyNonResponse);
  }

  // add start 要件No.26 スケジュール個別色換え
  /**
   * 個別色を返します。
   * 
   * @return 個別色（色コード）
   */
  public String getIndividualColor() {
    return individualColor;
  }

  /**
   * 個別色を設定します。
   * 
   * @param value
   *          色コード
   */
  public void setIndividualColor(String value) {
    individualColor = value;
  }
  // add end

}
