/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 *
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.schedule.beans;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;

/**
 * 予定登録先一覧リスト用のbeanクラスです
 */
public class ScheduleLocationUserBean implements ALData {

  /** 予定登録先(パラメータ) */
  private ALNumberField user_id;

  /** 予定登録先(表示名) */
  private ALStringField display_name;

  /**
   * オブジェクトのフィールドを初期化するメソッドです。
   */
  public void initField() {
    user_id = new ALNumberField();
    display_name = new ALStringField();
  }

  /**
   * @param int ユーザーID
   */
  public void setUserId(int uid) {
    user_id.setValue(uid);
  }

  /**
   * @return string ユーザーID
   */
  public String getUserId() {
    return user_id.toString();
  }

  /**
   * @return string 表示名
   */
  public void setDisplayName(String displayName) {
    display_name.setValue(displayName);
  }

  /**
   * @return string 表示名
   */
  public String getDisplayName() {
    return display_name.toString();
  }

}
