/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipo.com/
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import net.sf.json.JSONArray;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.schedule.ScheduleChangeIndividualColorFormData;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 個別色変更結果をJSON出力する
 */
public class ScheduleChangeIndividualColorJSONScreen extends ALJSONScreen {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ScheduleChangeIndividualColorJSONScreen.class.getName());

  /*
   * @see com.aimluck.eip.modules.screens.ALJSONScreen#getJSONString(RunData
   * rundata, Context context)
   */
  @Override
  protected String getJSONString(RunData rundata, Context context) throws Exception {
    String result = null;
    JSONArray json = null;

    try {
      // 個別色更新を実施
      ScheduleChangeIndividualColorFormData formData = new ScheduleChangeIndividualColorFormData();
      formData.initField();
      if (formData.doUpdate(this, rundata, context)) {
        // 正常終了時
        json = JSONArray.fromObject("[\"" + formData.getSuccessMsg() + "\"]");
      } else {
        // 異常終了時
        json = JSONArray.fromObject(context.get(ALEipConstants.ERROR_MESSAGE_LIST));
      }
      result = json.toString();
    } catch (Exception e) {
      // 当クラスでランタイムエラー発生時
      logger.error("スケジュールマップの個別色更新に失敗しました。ログインユーザー:"
        + ALEipUtils.getALEipUser(rundata).getName()
        + "/スケジュールID："
        + rundata.getParameters().getString(ALEipConstants.ENTITY_ID)
        + "/対象ユーザー:"
        + rundata.getParameters().getString("userid"), e);
      json = JSONArray.fromObject("[\"" + JSON_EX_MSG_RUNTIME + "\"]");
      result = json.toString();
    }

    return result;
  }
}
