/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import javax.servlet.http.HttpServletResponse;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.addressbook.AddressBookCorpFilterdSelectData;
import com.aimluck.eip.addressbook.AddressBookFilterdSelectData;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 個人アドレスの詳細画面を処理するクラスです。
 * 
 */
public class AddressBookDetailScreen extends ALVelocityScreen {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService
      .getLogger(AddressBookDetailScreen.class.getName());

  /**
   * 詳細画面表示処理
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   */
  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {
    try {
      ALAbstractSelectData<?, ?> detailData = null;
      String selectedTab = rundata.getParameters().getString("tab");
      if ("corp".equals(selectedTab)) {
        detailData = new AddressBookCorpFilterdSelectData();
      } else {
        detailData = new AddressBookFilterdSelectData();
      }
      detailData.initField();

      // change start
      // detailData.doViewDetail(this, rundata, context);
      //
      // String entityid =
      // ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID);
      // context.put(ALEipConstants.ENTITY_ID, entityid);
      // String layout_template = "portlets/html/ja/ajax-addressbook-detail.vm";
      String layout_template = null;
      if (detailData.doViewDetail(this, rundata, context)) {
        String entityid =
          ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID);
        context.put(ALEipConstants.ENTITY_ID, entityid);
        layout_template = "portlets/html/ja/ajax-addressbook-detail.vm";
      } else {
        layout_template = "portlets/html/ja/DBErrorForWindow.vm";
      }
      // change end

      // add by motegi start
      HttpServletResponse response = rundata.getResponse();
      response.setContentType("text/html; "
        + ALEipConstants.DEF_CONTENT_ENCODING);
      // add end

      setTemplate(rundata, context, layout_template);
    } catch (Exception ex) {
      // change start
      // logger.error("[AddressBookDetailScreen] Exception.", ex);
      logger.error("個人アドレス詳細画面表示処理に失敗しました。", ex);
      // change end
      // del start
      // ALEipUtils.redirectDBError(rundata);
      // del end
    }
  }

}
