/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.account.AccountUserSelectData;
import com.aimluck.eip.account.AccountUserWordSelectData;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.util.ALEipUtils;

/**
 * ユーザーアカウントの一覧を処理するクラスです。 <br />
 * 
 */
public class AccountUserListScreen extends AccountUserScreen {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(AccountUserListScreen.class.getName());

  /**
   * ユーザーの一覧表示処理
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   */
  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {

    // add by motegi
    String mode = rundata.getParameters().getString(ALEipConstants.MODE);
    try {
      // add start
      boolean success = false;
      // add end

      if ("ajaxsearch".equals(mode)) {
        AccountUserWordSelectData listData = new AccountUserWordSelectData();
        listData.initField();
        listData.setRowsNum(100);
        // change start
        // listData.doViewList(this, rundata, context);
        success = listData.doViewList(this, rundata, context);
        // change end
      } else {
        // add end
        AccountUserSelectData listData = new AccountUserSelectData();
        listData.initField();
        // change by motegi start
        // listData.setRowsNum(Integer.parseInt(ALEipUtils.getPortlet(
        // rundata,
        // context).getPortletConfig().getInitParameter("p1a-rows")));
        listData.setRowsNum(100);
        // change end
        // change start
        // listData.doViewList(this, rundata, context);
        success = listData.doViewList(this, rundata, context);
        // change end
        // add start
      }
      // add end

      String layout_template = "portlets/html/ja/ajax-account-user.vm";
      // add start
      if (!success) {
        layout_template = "portlets/html/ja/DBError.vm";
      }
      // add end

      setTemplate(rundata, context, layout_template);

    } catch (Exception ex) {
      logger.error("[AccountUserListScreen] Exception.", ex);
      ALEipUtils.redirectDBError(rundata);
    }
  }
}
