package org.apache.jetspeed.om.dbregistry;


import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.ObjectUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.ComboKey;
import org.apache.torque.om.DateKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.StringKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Transaction;


/**
 * This class was autogenerated by Torque on:
 *
 * [Thu Jun 10 23:17:32 JST 2004]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to Mediatype
 */
public abstract class BaseMediatype extends BaseObject
{
    /** The Peer class */
    private static final MediatypePeer peer =
        new MediatypePeer();

      
    /** The value for the id field */
    private long id;
      
    /** The value for the name field */
    private String name;
                                                                
    /** The value for the hidden field */
    private boolean hidden=false;
      
    /** The value for the mimetype field */
    private String mimetype;
      
    /** The value for the role field */
    private String role;
      
    /** The value for the title field */
    private String title;
      
    /** The value for the description field */
    private String description;
      
    /** The value for the image field */
    private String image;
  
  
    /**
     * Get the Id
     * @return long
     */
    public long getId()
    {
        return id;
    }

                                              
    /**
     * Set the value of Id
     */
    public void setId(long v ) throws TorqueException
    {
    
                  if (this.id != v)
              {
            this.id = v;
            setModified(true);
        }
    
          
                                  
        // update associated PortletMediatype
        if (collPortletMediatypes != null )
        {
            for (int i = 0; i < collPortletMediatypes.size(); i++)
            {
                ((PortletMediatype)collPortletMediatypes.get(i))
                        .setMediaId(v);
            }
        }
                      }

  
    /**
     * Get the Name
     * @return String
     */
    public String getName()
    {
        return name;
    }

                        
    /**
     * Set the value of Name
     */
    public void setName(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.name, v))
              {
            this.name = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Hidden
     * @return boolean
     */
    public boolean getHidden()
    {
        return hidden;
    }

                        
    /**
     * Set the value of Hidden
     */
    public void setHidden(boolean v ) 
    {
    
                  if (this.hidden != v)
              {
            this.hidden = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Mimetype
     * @return String
     */
    public String getMimetype()
    {
        return mimetype;
    }

                        
    /**
     * Set the value of Mimetype
     */
    public void setMimetype(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.mimetype, v))
              {
            this.mimetype = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Role
     * @return String
     */
    public String getRole()
    {
        return role;
    }

                        
    /**
     * Set the value of Role
     */
    public void setRole(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.role, v))
              {
            this.role = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Title
     * @return String
     */
    public String getTitle()
    {
        return title;
    }

                        
    /**
     * Set the value of Title
     */
    public void setTitle(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.title, v))
              {
            this.title = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Description
     * @return String
     */
    public String getDescription()
    {
        return description;
    }

                        
    /**
     * Set the value of Description
     */
    public void setDescription(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.description, v))
              {
            this.description = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Image
     * @return String
     */
    public String getImage()
    {
        return image;
    }

                        
    /**
     * Set the value of Image
     */
    public void setImage(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.image, v))
              {
            this.image = v;
            setModified(true);
        }
    
          
              }

  
         
                                
            
    /**
     * Collection to store aggregation of collPortletMediatypes
     */
    protected List collPortletMediatypes;

    /**
     * Temporary storage of collPortletMediatypes to save a possible db hit in
     * the event objects are add to the collection, but the
     * complete collection is never requested.
     */
    protected void initPortletMediatypes()
    {
        if (collPortletMediatypes == null)
        {
            collPortletMediatypes = new ArrayList();
        }
    }

            
    /**
     * Method called to associate a PortletMediatype object to this object
     * through the PortletMediatype foreign key attribute
     *
     * @param PortletMediatype l
     */
    public void addPortletMediatype(PortletMediatype l) throws TorqueException
    {
        getPortletMediatypes().add(l);
        l.setMediatype((Mediatype)this);
    }

    /**
     * The criteria used to select the current contents of collPortletMediatypes
     */
    private Criteria lastPortletMediatypesCriteria = null;

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getPortletMediatypes(new Criteria())
     */
    public List getPortletMediatypes() throws TorqueException
    {
        if (collPortletMediatypes == null)
        {
            collPortletMediatypes = getPortletMediatypes(new Criteria(10));
        }
        return collPortletMediatypes;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Mediatype has previously
     * been saved, it will retrieve related PortletMediatypes from storage.
     * If this Mediatype is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     */
    public List getPortletMediatypes(Criteria criteria) throws TorqueException
    {
        if (collPortletMediatypes == null)
        {
            if (isNew())
            {
               collPortletMediatypes = new ArrayList();
            }
            else
            {
                      criteria.add(PortletMediatypePeer.MEDIA_ID, getId() );
                      collPortletMediatypes = PortletMediatypePeer.doSelect(criteria);
            }
        }
        else
        {
            // criteria has no effect for a new object
            if (!isNew())
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                      criteria.add(PortletMediatypePeer.MEDIA_ID, getId() );
                      if (!lastPortletMediatypesCriteria.equals(criteria))
                {
                    collPortletMediatypes = PortletMediatypePeer.doSelect(criteria);
                }
            }
        }
        lastPortletMediatypesCriteria = criteria;

        return collPortletMediatypes;
    }

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getPortletMediatypes(new Criteria(),Connection)
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List getPortletMediatypes(Connection con) throws TorqueException
    {
        if (collPortletMediatypes == null)
        {
            collPortletMediatypes = getPortletMediatypes(new Criteria(10),con);
        }
        return collPortletMediatypes;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Mediatype has previously
     * been saved, it will retrieve related PortletMediatypes from storage.
     * If this Mediatype is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List getPortletMediatypes(Criteria criteria,Connection con) throws TorqueException
    {
        if (collPortletMediatypes == null)
        {
            if (isNew())
            {
               collPortletMediatypes = new ArrayList();
            }
            else
            {
                       criteria.add(PortletMediatypePeer.MEDIA_ID, getId() );
                       collPortletMediatypes = PortletMediatypePeer.doSelect(criteria,con);
             }
         }
         else
         {
             // criteria has no effect for a new object
             if (!isNew())
             {
                 // the following code is to determine if a new query is
                 // called for.  If the criteria is the same as the last
                 // one, just return the collection.
                     criteria.add(PortletMediatypePeer.MEDIA_ID, getId() );
                     if (!lastPortletMediatypesCriteria.equals(criteria))
                 {
                     collPortletMediatypes = PortletMediatypePeer.doSelect(criteria,con);
                 }
             }
         }
         lastPortletMediatypesCriteria = criteria;

         return collPortletMediatypes;
     }

                        

              
                    
                    
                                
                                                              
                                        
                    
                    
          
    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Mediatype is new, it will return
     * an empty collection; or if this Mediatype has previously
     * been saved, it will retrieve related PortletMediatypes from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Mediatype.
     */
    protected List getPortletMediatypesJoinPortletDbEntry(Criteria criteria)
        throws TorqueException
    {
        if (collPortletMediatypes == null)
        {
            if (isNew())
            {
               collPortletMediatypes = new ArrayList();
            }
            else
            {
                            criteria.add(PortletMediatypePeer.MEDIA_ID, getId() );
                            collPortletMediatypes = PortletMediatypePeer.doSelectJoinPortletDbEntry(criteria);
            }
        }
        else
        {
            // the following code is to determine if a new query is
            // called for.  If the criteria is the same as the last
            // one, just return the collection.
            boolean newCriteria = true;
                            criteria.add(PortletMediatypePeer.MEDIA_ID, getId() );
                        if (!lastPortletMediatypesCriteria.equals(criteria))
            {
                collPortletMediatypes = PortletMediatypePeer.doSelectJoinPortletDbEntry(criteria);
            }
        }
        lastPortletMediatypesCriteria = criteria;

        return collPortletMediatypes;
    }
                  
                    
                              
                                
                                                              
                                        
                    
                    
          
    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Mediatype is new, it will return
     * an empty collection; or if this Mediatype has previously
     * been saved, it will retrieve related PortletMediatypes from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Mediatype.
     */
    protected List getPortletMediatypesJoinMediatype(Criteria criteria)
        throws TorqueException
    {
        if (collPortletMediatypes == null)
        {
            if (isNew())
            {
               collPortletMediatypes = new ArrayList();
            }
            else
            {
                            criteria.add(PortletMediatypePeer.MEDIA_ID, getId() );
                            collPortletMediatypes = PortletMediatypePeer.doSelectJoinMediatype(criteria);
            }
        }
        else
        {
            // the following code is to determine if a new query is
            // called for.  If the criteria is the same as the last
            // one, just return the collection.
            boolean newCriteria = true;
                            criteria.add(PortletMediatypePeer.MEDIA_ID, getId() );
                        if (!lastPortletMediatypesCriteria.equals(criteria))
            {
                collPortletMediatypes = PortletMediatypePeer.doSelectJoinMediatype(criteria);
            }
        }
        lastPortletMediatypesCriteria = criteria;

        return collPortletMediatypes;
    }
                            


          
    private static List fieldNames = null;

    /**
     * Generate a list of field names.
     */
    public static synchronized List getFieldNames()
    {
        if (fieldNames == null)
        {
            fieldNames = new ArrayList();
              fieldNames.add("Id");
              fieldNames.add("Name");
              fieldNames.add("Hidden");
              fieldNames.add("Mimetype");
              fieldNames.add("Role");
              fieldNames.add("Title");
              fieldNames.add("Description");
              fieldNames.add("Image");
              fieldNames = Collections.unmodifiableList(fieldNames);
        }
        return fieldNames;
    }

    /**
     * Retrieves a field from the object by name passed in
     * as a String.
     */
    public Object getByName(String name)
    {
          if (name.equals("Id"))
        {
                return new Long(getId());
            }
          if (name.equals("Name"))
        {
                return getName();
            }
          if (name.equals("Hidden"))
        {
                return new Boolean(getHidden());
            }
          if (name.equals("Mimetype"))
        {
                return getMimetype();
            }
          if (name.equals("Role"))
        {
                return getRole();
            }
          if (name.equals("Title"))
        {
                return getTitle();
            }
          if (name.equals("Description"))
        {
                return getDescription();
            }
          if (name.equals("Image"))
        {
                return getImage();
            }
          return null;
    }
    
    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     */
    public Object getByPeerName(String name)
    {
          if (name.equals(MediatypePeer.ID ))
        {
                return new Long(getId());
            }
          if (name.equals(MediatypePeer.NAME ))
        {
                return getName();
            }
          if (name.equals(MediatypePeer.HIDDEN ))
        {
                return new Boolean(getHidden());
            }
          if (name.equals(MediatypePeer.MIMETYPE ))
        {
                return getMimetype();
            }
          if (name.equals(MediatypePeer.ROLE ))
        {
                return getRole();
            }
          if (name.equals(MediatypePeer.TITLE ))
        {
                return getTitle();
            }
          if (name.equals(MediatypePeer.DESCRIPTION ))
        {
                return getDescription();
            }
          if (name.equals(MediatypePeer.IMAGE ))
        {
                return getImage();
            }
          return null;
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     */
    public Object getByPosition(int pos)
    {
            if ( pos == 0 )
        {
                return new Long(getId());
            }
              if ( pos == 1 )
        {
                return getName();
            }
              if ( pos == 2 )
        {
                return new Boolean(getHidden());
            }
              if ( pos == 3 )
        {
                return getMimetype();
            }
              if ( pos == 4 )
        {
                return getRole();
            }
              if ( pos == 5 )
        {
                return getTitle();
            }
              if ( pos == 6 )
        {
                return getDescription();
            }
              if ( pos == 7 )
        {
                return getImage();
            }
              return null;
    }
     
    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     */
    public void save() throws Exception
    {
          save(MediatypePeer.getMapBuilder()
                .getDatabaseMap().getName());
      }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
       * Note: this code is here because the method body is
     * auto-generated conditionally and therefore needs to be
     * in this file instead of in the super class, BaseObject.
       */
    public void save(String dbName) throws TorqueException
    {
        Connection con = null;
          try
        {
            con = Transaction.begin(dbName);
            save(con);
            Transaction.commit(con);
        }
        catch(TorqueException e)
        {
            Transaction.safeRollback(con);
            throw e;
        }
      }

      /** flag to prevent endless save loop, if this object is referenced
        by another object which falls in this transaction. */
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     */
    public void save(Connection con) throws TorqueException
    {
          if (!alreadyInSave)
        {
            alreadyInSave = true;


  
            // If this object has been modified, then save it to the database.
            if (isModified())
            {
                if (isNew())
                {
                    MediatypePeer.doInsert((Mediatype)this, con);
                    setNew(false);
                }
                else
                {
                    MediatypePeer.doUpdate((Mediatype)this, con);
                }

                      if (isCacheOnSave())
                {
                    MediatypeManager.putInstance(this);
                }
              }

                                      
                            if (collPortletMediatypes != null )
            {
                for (int i = 0; i < collPortletMediatypes.size(); i++)
                {
                    ((PortletMediatype)collPortletMediatypes.get(i)).save(con);
                }
            }
                          alreadyInSave = false;
        }
      }

    /**
     * Specify whether to cache the object after saving to the db.
     * This method returns false
     */
    protected boolean isCacheOnSave()
    {
        return true;
    }

                        
      /**
     * Set the PrimaryKey using ObjectKey.
     *
     * @param ObjectKey id
     */
    public void setPrimaryKey(ObjectKey id)
        throws TorqueException {
            setId(((NumberKey)id).longValue());
        }

    /**
     * Set the PrimaryKey using a String.
     */
    public void setPrimaryKey(String key) throws TorqueException
    {
            setId(Long.parseLong(key));
        }

  
    /**
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey()
    {
          return SimpleKey.keyFor(getId());
      }
 

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
       * It then fills all the association collections.
       */
      public Mediatype copy() throws TorqueException
    {
        Mediatype copyObj = new Mediatype();
            copyObj.setId(id);
          copyObj.setName(name);
          copyObj.setHidden(hidden);
          copyObj.setMimetype(mimetype);
          copyObj.setRole(role);
          copyObj.setTitle(title);
          copyObj.setDescription(description);
          copyObj.setImage(image);
  
                      copyObj.setId(0);
                                                      
                                      
                
        List v = getPortletMediatypes();
        for (int i = 0; i < v.size(); i++)
        {
            PortletMediatype obj = (PortletMediatype) v.get(i);
            copyObj.addPortletMediatype(obj.copy());
        }
                            return copyObj;
    }

    /**
     * returns a peer instance associated with this om.  Since Peer classes
     * are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     */
    public MediatypePeer getPeer()
    {
        return peer;
    }
}
