/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.annogen.override.internal;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.annogen.override.AnnoBean;
import org.codehaus.annogen.override.AnnoBeanSet;
import org.codehaus.annogen.override.AnnoContext;
import org.codehaus.annogen.override.ElementId;
import org.codehaus.annogen.override.StoredAnnoOverrider;
import org.codehaus.annogen.override.internal.AnnoBeanSetImpl;

public class StoredAnnoOverriderImpl
implements StoredAnnoOverrider {
    private Map mId2APS = new HashMap();
    private AnnoContext mContext;

    public StoredAnnoOverriderImpl(AnnoContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("null ctx");
        }
        this.mContext = ctx;
    }

    public StoredAnnoOverriderImpl() {
        this.mContext = AnnoContext.Factory.newInstance();
    }

    public AnnoBeanSet findOrCreateStoredAnnoSetFor(ElementId id) {
        AnnoBeanSet out = (AnnoBeanSet)this.mId2APS.get(id);
        if (out == null) {
            out = new AnnoBeanSetImpl(this.mContext);
            this.mId2APS.put(id, out);
        }
        return out;
    }

    public void init(AnnoContext ctx) {
        this.mContext = ctx;
    }

    public void modifyAnnos(ElementId id, AnnoBeanSet currentAnnos) {
        AnnoBeanSet stored = (AnnoBeanSet)this.mId2APS.get(id);
        if (stored == null) {
            return;
        }
        AnnoBean[] proxies = stored.getAll();
        if (proxies == null || proxies.length == 0) {
            return;
        }
        for (int i = 0; i < proxies.length; ++i) {
            currentAnnos.put(proxies[i]);
        }
    }
}

