/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.annogen.override.internal;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.annogen.override.AnnoBean;
import org.codehaus.annogen.override.AnnoBeanMapping;
import org.codehaus.annogen.override.AnnoBeanSet;
import org.codehaus.annogen.override.AnnoContext;
import org.codehaus.jam.provider.JamLogger;

public class AnnoBeanSetImpl
implements AnnoBeanSet {
    private Map mBeanClass2AnnoClass = new HashMap();
    private AnnoBeanMapping mTypeMapping = null;
    private JamLogger mLogger = null;
    private AnnoContext mContext = null;

    public AnnoBeanSetImpl(AnnoContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException();
        }
        this.mTypeMapping = ctx.getAnnoBeanMapping();
        this.mLogger = ctx.getLogger();
        this.mContext = ctx;
    }

    public boolean containsBeanFor(Class requestedClass) {
        Class beanClass;
        try {
            beanClass = this.mTypeMapping.getAnnoBeanClassForRequest(requestedClass);
        }
        catch (ClassNotFoundException cnfe) {
            this.mLogger.error(cnfe);
            return false;
        }
        return this.mBeanClass2AnnoClass.containsKey(beanClass);
    }

    public AnnoBean findOrCreateBeanFor(Class requestedClass) {
        Class beanClass;
        try {
            beanClass = this.mTypeMapping.getAnnoBeanClassForRequest(requestedClass);
        }
        catch (ClassNotFoundException cnfe) {
            this.mLogger.error(cnfe);
            return null;
        }
        AnnoBean ap = (AnnoBean)this.mBeanClass2AnnoClass.get(beanClass);
        if (ap != null) {
            return ap;
        }
        ap = this.mContext.createAnnoBeanFor(beanClass);
        if (ap != null) {
            this.mBeanClass2AnnoClass.put(beanClass, ap);
            return ap;
        }
        return null;
    }

    public void put(AnnoBean bean) {
        if (bean == null) {
            throw new IllegalArgumentException();
        }
        this.mBeanClass2AnnoClass.put(bean.getClass(), bean);
    }

    public AnnoBean removeBeanFor(Class requestedClass) {
        Class beanClass;
        try {
            beanClass = this.mTypeMapping.getAnnoBeanClassForRequest(requestedClass);
        }
        catch (ClassNotFoundException cnfe) {
            this.mLogger.error(cnfe);
            return null;
        }
        return (AnnoBean)this.mBeanClass2AnnoClass.remove(beanClass);
    }

    public AnnoBean[] getAll() {
        AnnoBean[] out = new AnnoBean[this.mBeanClass2AnnoClass.values().size()];
        this.mBeanClass2AnnoClass.values().toArray(out);
        return out;
    }

    public int size() {
        return this.mBeanClass2AnnoClass.size();
    }
}

