/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef STYLE_FILL_INCLUDED
#define STYLE_FILL_INCLUDED

#include "Option.h"

//! set style fill コマンド
class StyleFill : public Option
{
	public:
		StyleFill();

		void setEmpty();
		bool isEmpty() const;

		void setSolid();
		bool isSolid() const;

		void setDensity(double density);
		double density() const;

		void setPattern();
		bool isPattern() const;

		void setPattern(int n);
		int pattern() const;

		void setBorder(bool border);
		bool isBorder() const;

		void setLineType(int type);
		int lineType() const;

		QString command() const;

	private:
		static const int EMPTY;
		static const int SOLID;
		static const int PATTERN;

		static const int DEFAULT_LINE_TYPE;

		int style_;
		double density_;
		int pattern_;
		bool isBorder_;
		int lineType_;
};
#endif // STYLE_FILL_INCLUDED
