/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "StyleFill.h"

#include <QtCore/QString>

const int StyleFill::EMPTY = 0;
const int StyleFill::SOLID = 1;
const int StyleFill::PATTERN = 2;

const int StyleFill::DEFAULT_LINE_TYPE = -1;

StyleFill::StyleFill() : style_(EMPTY), density_(1.0), pattern_(0),
	isBorder_(true), lineType_(DEFAULT_LINE_TYPE)
{
}

void StyleFill::setEmpty()
{
	style_ = EMPTY;
}

bool StyleFill::isEmpty() const
{
	return style_ == EMPTY;
}

void StyleFill::setSolid()
{
	style_ = SOLID;
}

bool StyleFill::isSolid() const
{
	return style_ == SOLID;
}

void StyleFill::setDensity(double density)
{
	style_ = SOLID;
	density_ = density;
}

double StyleFill::density() const
{
	return density_;
}

void StyleFill::setPattern()
{
	style_ = PATTERN;
}

bool StyleFill::isPattern() const
{
	return style_ == PATTERN;
}

void StyleFill::setPattern(int n)
{
	style_ = PATTERN;
	pattern_ = n;
}

int StyleFill::pattern() const
{
	return pattern_;
}

void StyleFill::setBorder(bool border)
{
	isBorder_ = border;
}

bool StyleFill::isBorder() const
{
	return isBorder_;
}

void StyleFill::setLineType(int type)
{
	lineType_ = type;
}

int StyleFill::lineType() const
{
	return lineType_;
}

QString StyleFill::command() const
{
	QString str = "set style fill ";
	if (style_ == EMPTY) {
		str += "empty ";
	} else if (style_ == SOLID) {
		str += "solid " + QString::number(density_) + " ";
	} else if (style_ == PATTERN) {
		str += "pattern " + QString::number(pattern_) + " ";
	}
	if (isBorder_) {
		str += "border";
	} else {
		str += "noborder";
		if (lineType_ != DEFAULT_LINE_TYPE) {
			str += " " + QString::number(lineType_);
		}
	}
	return str;
}
