/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef TITLE_INCLUDED
#define TITLE_INCLUDED

#include "Option.h"

#include <QtCore/QString>

//! set title コマンド
class Title : public Option
{
	public:
		Title();

		void setTitleText(const QString &text);
		const QString &titleText() const;

		void setXOffset(double xoff);
		double xOffset() const;

		void setYOffset(double yoff);
		double yOffset() const;

		void setFontName(const QString &name);
		const QString &fontName() const;

		void setFontSize(double size);
		double fontSize() const;

		void setLineType(int lt);
		int lineType() const;

		QString command() const;

	private:
		static const double DEFAULT_FONT_SIZE;
		static const int DEFAULT_LINE_TYPE = 0;
		QString titleText_;
		double xOffset_;
		double yOffset_;
		QString fontName_;
		double fontSize_;
		int lineType_;
};
#endif // TITLE_INCLUDED
