/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "Title.h"

const double Title::DEFAULT_FONT_SIZE = 0;

Title::Title() : xOffset_(0.000000), yOffset_(0.000000), 
	fontSize_(DEFAULT_FONT_SIZE), lineType_(DEFAULT_LINE_TYPE)
{
}

void Title::setTitleText(const QString &text)
{
	titleText_ = text;
}

const QString &Title::titleText() const
{
	return titleText_;
}

void Title::setXOffset(double xoff)
{
	xOffset_ = xoff;
}

double Title::xOffset() const
{
	return xOffset_;
}

void Title::setYOffset(double yoff)
{
	yOffset_ = yoff;
}

double Title::yOffset() const
{
	return yOffset_;
}

void Title::setFontName(const QString &name)
{
	fontName_ = name;
}

const QString &Title::fontName() const
{
	return fontName_;
}

void Title::setFontSize(double size)
{
	fontSize_ = size;
}

double Title::fontSize() const
{
	return fontSize_;
}

void Title::setLineType(int lt)
{
	lineType_ = lt;
}

int Title::lineType() const
{
	return lineType_;
}

QString Title::command() const
{
	QString str = "set title";
	str += " \"" + titleText_
		+ "\" " + QString::number(xOffset_) + "," 
		+ QString::number(yOffset_) + " font \"" 
		+ fontName_;
	if (fontSize_ != DEFAULT_FONT_SIZE) {
		str += "," + QString::number(fontSize_);
	}
	str += "\"";
	if (lineType_ != DEFAULT_LINE_TYPE) {
		str += " textcolor lt " 
			+ QString::number(lineType_);
	}
	return str;
}
