/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef AXIS_TICS_INCLUDED
#define AXIS_TICS_INCLUDED

#include "Option.h"

#include <QtCore/QString>
#include <QtCore/QStringList>

//! set {axis}tics コマンド
class AxisTics : public Option
{
	public:
		AxisTics();

		void setFlag(int axis, bool flag);
		bool flag(int axis) const;

		void setMirror(int axis, bool mirror);
		bool mirrors(int axis) const;

		void setBorder(int axis, bool border);
		bool isBorder(int axis) const;

		void setRotate(int axis, bool rotate,
				const QString &ang = QString());
		bool rotates(int axis) const;

		void setAutofreq(int axis);
		bool isAutofreq(int axis) const;

		void setIncrement(int axis, const QString &incr, 
				const QString &start = QString(), 
				const QString &end = QString());
		bool isIncrement(int axis) const;
		const QString &start(int axis) const;
		const QString &increment(int axis) const;
		const QString &end(int axis) const;

		void setPosition(int axis, const QStringList &pos);
		bool isPosition(int axis) const;
		const QStringList &position(int axis) const;

		QString command() const;

		//! 軸
		static const QString AXIS[];
		//! 目盛りの場所
		static const char * const LOCATION[];
	private:
		QList<bool> flagList;
		QList<bool> borderList;
		QList<bool> mirrorList;
		QList<bool> rotateList;
		QList<QString> angList;

		QList<int> modeList;

		static const int AUTOFREQ;
		static const int INCR;
		static const int POS;

		QList<QString> incrList[3];

		QList<QStringList> posList;
};
#endif // AXIS_TICS_INCLUDED
