/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "AxisRange.h"

#include <QtCore/QStringList>

const QString AxisRange::AXIS[] = {
	"x", "y", "z", "x2", "y2", "cb", "r", "t", "u", "v", ""
};

AxisRange::AxisRange()
{
	for (int i = 0; !AXIS[i].isEmpty(); i++) {
		minList.append("*");
		maxList.append("*");
		reverseList.append(false);
		writeBackList.append(false);
		restoreList.append(false);
	}
}

void AxisRange::setMinimum(int axis, const QString &min)
{
	minList[axis] = min;
}

const QString &AxisRange::minimum(int axis) const
{
	return minList.at(axis);
}

void AxisRange::setMaximum(int axis, const QString &max)
{
	maxList[axis] = max;
}

const QString &AxisRange::maximum(int axis) const
{
	return maxList.at(axis);
}

void AxisRange::setReverse(int axis, bool reverse)
{
	reverseList[axis] = reverse;
}

bool AxisRange::isReverse(int axis) const
{
	return reverseList.at(axis);
}

void AxisRange::setWrittenBack(int axis, bool writeBack)
{
	writeBackList[axis] = writeBack;
}

bool AxisRange::writeBacks(int axis) const
{
	return writeBackList.at(axis);
}

void AxisRange::setRestored(int axis, bool restore)
{
	restoreList[axis] = restore;
}

bool AxisRange::restores(int axis) const
{
	return restoreList.at(axis);
}

QString AxisRange::command() const
{
	QStringList commandList;
	for (int i = 0; !AXIS[i].isEmpty(); i++) {
		QString str = "set " + AXIS[i] + "range ";
		if (restoreList.at(i)) {
			str += "restore";
			commandList << str;
		} else {
			str += "[ " + minList.at(i) + " : " + 
				maxList.at(i) + " ] ";
			str += reverseList.at(i) ? "" : "no";
			str += "reverse ";
			str += writeBackList.at(i) ? "" : "no";
			str += "writeback";
			commandList << str;
		}
	}
	return commandList.join("\n");
}
