#!/bin/sh

for file in `find . -name '*.cpp' -or -name '*.h'`
do
	# ex.
	# #include "Plot.h" -> Plot
	# #include <cmath> // pow() -> cmath
	# #include <QtCore/QString> -> QString 
	# #include <QtGui/QPushButton> -> QPushButton
	class_name=`grep '#include' $file | sed 's/#include\s\+//' | sed '/"/s,\("\|\.h\),,g' | sed '/</s,\(<\|Qt\(Core\|Gui\)/\|>\),,g' | sed 's://.*::'`
	for str in $class_name
	do
		num=`grep "\<$str\>" $file | wc -l`
		if test $num -le 1 
		then
			echo $file - $str
		fi
	done
done
