/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "StyleFillOptionWidget.h"
#include "StyleFill.h"

#include <QtGui/QCheckBox>
#include <QtGui/QDoubleSpinBox>
#include <QtGui/QGridLayout>
#include <QtGui/QRadioButton>
#include <QtGui/QSpinBox>

StyleFillOptionWidget::StyleFillOptionWidget(QWidget *parent)
: OptionWidget(parent), styleFill(0)
{
}

StyleFillOptionWidget::~StyleFillOptionWidget()
{
	delete styleFill;
}

void StyleFillOptionWidget::construct() 
{
	setWhatsThis("set style fill");

	emptyRadioButton = new QRadioButton;
	emptyRadioButton->setText(tr("&Empty"));
	connect(emptyRadioButton, SIGNAL(toggled(bool)),
			this, SIGNAL(modified()));

	solidRadioButton = new QRadioButton;
	solidRadioButton->setText(tr("&Solid:"));
	connect(solidRadioButton, SIGNAL(toggled(bool)),
			this, SIGNAL(modified()));

	solidDoubleSpinBox = new QDoubleSpinBox;
	solidDoubleSpinBox->setMaximum(1.0);
	solidDoubleSpinBox->setSingleStep(0.1);
	connect(solidRadioButton, SIGNAL(toggled(bool)),
			solidDoubleSpinBox, SLOT(setEnabled(bool)));
	connect(solidDoubleSpinBox, SIGNAL(valueChanged(double)),
			this, SIGNAL(modified()));

	patternRadioButton = new QRadioButton;
	patternRadioButton->setText(tr("&Pattern:"));
	connect(patternRadioButton, SIGNAL(toggled(bool)),
			this, SIGNAL(modified()));

	patternSpinBox = new QSpinBox;
	connect(patternRadioButton, SIGNAL(toggled(bool)),
			patternSpinBox, SLOT(setEnabled(bool)));
	connect(patternSpinBox, SIGNAL(valueChanged(int)),
			this, SIGNAL(modified()));

	borderCheckBox = new QCheckBox;
	borderCheckBox->setText(tr("&Border"));
	connect(borderCheckBox, SIGNAL(toggled(bool)),
			this, SIGNAL(modified()));

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(emptyRadioButton, 0, 0);
	mainLayout->addWidget(solidRadioButton, 1, 0);
	mainLayout->addWidget(solidDoubleSpinBox, 1, 1);
	mainLayout->addItem(new QSpacerItem(0, 0, 
				QSizePolicy::Expanding, QSizePolicy::Minimum), 1, 2);
	mainLayout->addWidget(patternRadioButton, 2, 0);
	mainLayout->addWidget(patternSpinBox, 2, 1);
	mainLayout->addWidget(borderCheckBox, 3, 0);
	mainLayout->addItem(new QSpacerItem(0, 0,
				QSizePolicy::Minimum, QSizePolicy::Expanding), 4, 0);

	setLayout(mainLayout);
}

void StyleFillOptionWidget::init()
{
	delete styleFill;
	styleFill = new StyleFill;
	setWidget();
}

void StyleFillOptionWidget::apply()
{
	if (emptyRadioButton->isChecked()) {
		styleFill->setEmpty();
	} else if (solidRadioButton->isChecked()) {
		styleFill->setDensity(solidDoubleSpinBox->value());
	} else {
		styleFill->setPattern(patternSpinBox->value());
	}
	styleFill->setBorder(borderCheckBox->isChecked());
	emit executed(styleFill->command());
}

void StyleFillOptionWidget::setWidget()
{
	solidDoubleSpinBox->setEnabled(styleFill->isSolid());
	solidDoubleSpinBox->setValue(styleFill->density());

	patternSpinBox->setEnabled(styleFill->isPattern());
	patternSpinBox->setValue(styleFill->pattern());
	if (styleFill->isEmpty()) {
		emptyRadioButton->setChecked(true);
	} else if (styleFill->isSolid()) {
		solidRadioButton->setChecked(true);
	} else {
		patternRadioButton->setChecked(true);
	}
	borderCheckBox->setChecked(styleFill->isBorder());
}
