/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2008 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "PlotListView.h"
#if QT_VERSION >= 0x040200
# include "misc.h"
#endif

#include <QtCore/QCoreApplication>
#if QT_VERSION >= 0x040200
# include <QtCore/QSettings>
# include <QtCore/QUrl>
# include <QtGui/QDesktopServices>
#endif
#include <QtGui/QAction>
#include <QtGui/QInputDialog>
#include <QtGui/QMenu>

PlotListView::PlotListView(QWidget *parent)
: QListView(parent)
{
	setContextMenuPolicy(Qt::CustomContextMenu);
	connect(this, SIGNAL(customContextMenuRequested(const QPoint &)),
			this, SLOT(showContextMenu(const QPoint &)));

#if QT_VERSION >= 0x040200
	QSettings settings;
	settings.beginGroup("PlotList");
	handler = settings.value("handler").toString();
	settings.endGroup();
	if (handler.isEmpty()) {
		QDesktopServices::unsetUrlHandler("file");
	} else {
		QDesktopServices::setUrlHandler("file", this, "setHandler");
	}
#endif
}

void PlotListView::showContextMenu(const QPoint &/*pos*/)
{
	QModelIndexList list = selectionModel()->selectedIndexes();
	if (!list.size()) {
		return;
	}
	QModelIndex index = list[0];
	QMenu *menu = new QMenu;
#if QT_VERSION >= 0x040200
	QAction *openAction = new QAction(tr("&Open"), this);
	openAction->setEnabled(!model()->data(index, Qt::UserRole + 1).toBool());
	menu->addAction(openAction);
#endif
	QAction *editAction = new QAction(tr("&Edit..."), this);
	menu->addAction(editAction);
	QAction *action = menu->exec(QCursor::pos());


#if QT_VERSION >= 0x040200
	if (action == openAction) {
		::openDataFile(model()->data(index).toString(), *this);
	} else
#endif
	if (action == editAction) {
		bool ok;
		QString text 
			= QInputDialog::getText(this, tr("Edit") + " - " 
					+ QCoreApplication::applicationName(),
					tr("An Item Name:"), QLineEdit::Normal,
					model()->data(index).toString(), &ok);
		// 文字列が空のときは変更しない
		if (ok && !text.isEmpty()) {
			model()->setData(index, QVariant(text));
		}
	}
}

#if QT_VERSION >= 0x040200
void PlotListView::setHandler(const QUrl &url)
{
	::openUrl(url, handler);
}
#endif
