/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLOT_MODIFIER_INCLUDED
#define PLOT_MODIFIER_INCLUDED

#include "CommandOption.h"

#include <QtCore/QString>
#include <QtCore/QStringList>

//! plot コマンドのオプション
class PlotModifier : public CommandOption
{
	public:
		PlotModifier();

		void setIndex(int m, int n = -1, int p = -1);
		int m() const;
		int n() const;
		int p() const;

		void setEvery(int pointIncr, int blockIncr,
				int startPoint, int startBlock,
				int endPoint, int endBlock);
		int pointIncrement() const;
		int blockIncrement() const;
		int startPoint() const;
		int startBlock() const;
		int endPoint() const;
		int endBlock() const;

		void setUsing(const QStringList &entry, const QString &format);
		const QStringList &entry() const;
		const QString &format() const;

		void setSmooth(int smooth);
		int smooth() const;

		QString option() const;

		static const QString SMOOTH[];
	private:
		static const int EVERY_NUM = 6;
		int m_;
		int n_;
		int p_;
		int everyArray[EVERY_NUM];
		QStringList entry_;
		QString format_;
		int smooth_;
};
#endif // PLOT_MODIFIER_INCLUDED
