/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLOT_INCLUDED
#define PLOT_INCLUDED

#include "Command.h"
#include "PlotRange.h"
#include "PlotModifier.h"
#include "PlotTitle.h"
#include "PlotStyle.h"

#include <QtCore/QString>

//! plot コマンド
class Plot : public Command
{
	public:
		Plot();

		void setRange(const PlotRange &range);
		const PlotRange &range() const;

		void setFunction(bool isFunction);
		bool isFunction() const;

		void setFunction(const QString &name);
		const QString &function() const;

		void setDataFile(const QString &name);
		const QString &dataFile() const;

		void setDataFileModifier(const PlotModifier &mod);
		const PlotModifier &dataFileModifier() const;

		void setAxis(int axis);
		int axis() const;

		void setTitleSpecification(const PlotTitle &title);
		const PlotTitle &titleSpecification() const;

		void setStyle(const PlotStyle &style);
		const PlotStyle &style() const;

		QString command() const;

		static const QString AXIS[];
	private:
		PlotRange range_;
		bool isFunction_;
		QString function_;
		QString dataFile_;
		PlotModifier dataFileModifier_;
		int axis_;
		PlotTitle titleSpecification_;
		PlotStyle style_;
};
#endif // PLOT_INCLUDED
