/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "FitModifier.h"

FitModifier::FitModifier()
{
}

void FitModifier::setIndex(int m, int n, int p)
{
	plotModifier.setIndex(m, n, p);
}

int FitModifier::m() const
{
	return plotModifier.m();
}

int FitModifier::n() const
{
	return plotModifier.n();
}

int FitModifier::p() const
{
	return plotModifier.p();
}

void FitModifier::setEvery(int pointIncr, int blockIncr,
		int startPoint, int startBlock,
		int endPoint, int endBlock)
{
	plotModifier.setEvery(pointIncr, blockIncr,
			startPoint, startBlock,
			endPoint, endBlock);
}

int FitModifier::pointIncrement() const
{
	return plotModifier.pointIncrement();
}

int FitModifier::blockIncrement() const
{
	return plotModifier.blockIncrement();
}

int FitModifier::startPoint() const
{
	return plotModifier.startPoint();
}

int FitModifier::startBlock() const
{
	return plotModifier.startBlock();
}

int FitModifier::endPoint() const
{
	return plotModifier.endPoint();
}

int FitModifier::endBlock() const
{
	return plotModifier.endBlock();
}

void FitModifier::setUsing(const QStringList &entry, const QString &format)
{
	plotModifier.setUsing(entry, format);
}

const QStringList &FitModifier::entry() const
{
	return plotModifier.entry();
}

const QString &FitModifier::format() const
{
	return plotModifier.format();
}

QString FitModifier::option() const
{
	return plotModifier.option();
}
