# Copyright 1999-2008 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: $

inherit qt4 toolchain-funcs

DESCRIPTION="A GUI front-end to gnuplot"
HOMEPAGE="http://sourceforge.jp/projects/cueplot/"
SRC_URI="mirror://sourceforge.jp/cueplot/30767/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~ppc ~x86"
IUSE="linguas_ja"

DEPEND="$(qt4_min_version 4.2)
		>=dev-util/cmake-2.4"
RDEPEND="$(qt4_min_version 4.2)
		>=sci-visualization/gnuplot-4.0"

src_unpack() {
	unpack "${A}"
	cd "${S}"
}

src_compile() {
	if has_version '>=x11-libs/qt-4.3.0' || ! use linguas_ja; then
		sed -ie 's:lang/qt_ja_JP.ts::' src/CMakeLists.txt
	fi
	if ! use linguas_ja; then
		sed -ie 's:lang/cueplot_ja_JP.ts::' src/CMakeLists.txt
	fi

	cmake \
		-DCMAKE_INSTALL_PREFIX=/usr	\
		-DCMAKE_BUILD_TYPE=Release \
		-DBIN_INSTALL_DIR=/usr/bin \
		-DLIB_INSTALL_DIR=/usr/$(get_libdir) \
		-DXDG_INSTALL_DIR=/usr/share/applications \
		-DCMAKE_C_COMPILER=$(type -P $(tc-getCC)) \
		-DCMAKE_CXX_COMPILER=$(type -P $(tc-getCXX)) \
		|| die "cmake failed"

	emake || die "make failed"
}

src_install() {
	emake DESTDIR="${D}" install || die "make install failed"
}
