// -*-Mode: C++;-*-
//
//  Cubic smooth spline interpolator class
//

#ifndef SMOOTH_SPLINE_HPP_INCLUDED
#define SMOOTH_SPLINE_HPP_INCLUDED

#include <modules/molvis/molvis.hpp>
#include <qlib/Vector4D.hpp>

namespace molvis {

  using qlib::Vector4D;

  class SmoothSpline
  {
  private:
    std::vector<Vector4D> m_veclist;

    int m_nPoints;
    Vector4D *m_pCoeff0;
    Vector4D *m_pCoeff1;
    Vector4D *m_pCoeff2;
    Vector4D *m_pCoeff3;

  public:
    SmoothSpline();

    ~SmoothSpline();

    /// reinitialization
    void cleanup();

    void setSize(int nsize) { m_veclist.resize(nsize); }

    /// Set interporation point
    void setPoint(int i, const Vector4D &vec) {
      m_veclist[i] = vec;
    }

    /// Generate spline coeffs
    bool generate();

    /// Calculate interpolation
    bool interpolate(double f, Vector4D *vec,
                     Vector4D *dvec = NULL, Vector4D *ddvec = NULL);

    /// Get the number of data points
    int getPoints() const { return m_nPoints; }
  };

}

#endif


