﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using System.IO;

namespace Utility
{
    public class Serializer
    {
        static public object Deserialization(string path, Type type)
        {
            XmlSerializer xs = null;
            FileStream fs = null;
            object obj = null;

            if (!File.Exists(path))
            {
                return obj;
            }

            try
            {
                xs = new XmlSerializer(type);
                fs = new FileStream(path, FileMode.Open);

                obj = xs.Deserialize(fs);
                fs.Close();
            }
            finally
            {
                if (fs != null)
                {
                    fs.Close();
                }
            }
            return obj;
        }

        static public void Serialization(string path, object obj)
        {
            FileStream fs = null;
            XmlSerializer xs = null;

            try
            {
                fs = new FileStream(path, FileMode.Create);
                xs = new XmlSerializer(obj.GetType());
                xs.Serialize(fs, obj);
            }
            finally
            {
                if (fs != null)
                {
                    fs.Close();
                }
            }
        }


    }
}
