﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections.ObjectModel;
using System.ComponentModel;

namespace CTester.UnitTest
{
    public class UTRoot : INotifyPropertyChanged, IUTTest
    {
        // ----------------------------------------
        // プロパティ
        // ----------------------------------------
        #region Properties

        protected ObservableCollection<UTGroups> _children = new ObservableCollection<UTGroups>();
        public ObservableCollection<UTGroups> Children
        {
            get
            {
                return _children;
            }
            set
            {
                _children = value;
            }
        }

        #endregion

        // ----------------------------------------
        // INotifyPropertyChangedインターフェース
        // ----------------------------------------
        #region INotifyPropertyChanged InterFace

        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        // ----------------------------------------
        // IUTTestインターフェース
        // ----------------------------------------
        #region IUTTestInterFace

        protected UTResultEnum _testResult = UTResultEnum.Non;
        public UTResultEnum TestResult
        {
            get
            {
                return _testResult;
            }
            set
            {
                _testResult = value;
                this.OnPropertyChanged("TestResult");
            }
        }

        public int TestCount
        {
            get
            {
                int sum = 0;
                foreach (var child in _children)
                {
                    sum += child.TestCount;
                }
                return sum;
            }
        }

        public List<UTTest> GetTestList()
        {
            var list = new List<UTTest>();

            foreach (var group in _children)
            {
                list.AddRange(group.GetTestList());
            }

            return list;
        }

        public void ExecTest()
        {
            foreach (var child in _children)
            {
                child.ExecTest();
            }

            if (_children.Any((x) => x.TestResult == UTResultEnum.NG))
            {
                TestResult = UTResultEnum.NG;
            }
            else
            {
                TestResult = UTResultEnum.OK;
            }
        }

        public void ClearResult()
        {
            foreach (var child in _children)
            {
                child.ClearResult();
            }
            TestResult = UTResultEnum.Non;
        }

        protected bool _isSelected = false;
        public bool IsSelected
        {
            get
            {
                return _isSelected;
            }


            set
            {
                _isSelected = value;
                this.OnPropertyChanged("IsSelected");
            }
        }

        #endregion

        // ----------------------------------------
        // メソッド
        // ----------------------------------------
        #region Methods

        public IUTTest SearchSelectedItem()
        {
            foreach (var groups in _children)
            {
                var item = groups.SearchSelectedItem();
                if (item != null)
                {
                    return item;
                }
            }

            return null;
        }

        #endregion

    }
}
