﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Data;
using System.Windows.Media.Imaging;
using System.Text;

namespace CTester.UnitTest
{
    public class UTItem2ImageConverter : IValueConverter
    {
        // ----------------------------------------
        // IValueConverterインターフェース
        // ----------------------------------------
        #region IValueConverter Interface

        object IValueConverter.Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            UTResultEnum result;

            if (value.GetType() != typeof(UTResultEnum))
            {
                return new BitmapImage(new Uri("pack://application:,,,/Images/Non.PNG"));
            }

            result = (UTResultEnum)value;

            switch (result)
            {
                case UTResultEnum.NG:
                    return new BitmapImage(new Uri("pack://application:,,,/Images/Ng.PNG"));
                case UTResultEnum.OK:
                    return new BitmapImage(new Uri("pack://application:,,,/Images/Ok.PNG"));
                default:
                    return new BitmapImage(new Uri("pack://application:,,,/Images/Non.PNG"));
            }
        }

        object IValueConverter.ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            throw new NotImplementedException();
        }

        #endregion
    }
}
