﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections.ObjectModel;
using System.ComponentModel;

namespace CTester.UnitTest
{
    public class UTGroups :INotifyPropertyChanged,IUTTest
    {
        // ----------------------------------------
        // プロパティ
        // ----------------------------------------
        #region Properties

        protected ObservableCollection<UTGroup> _children = new ObservableCollection<UTGroup>();
        public ObservableCollection<UTGroup> Children
        {
            get
            {
                return _children;
            }
            set
            {
                _children = value;
            }
        }

        protected string _name = "単体テスト";
        public string Name
        {
            get
            {
                return _name;
            }
            set
            {
                _name = value;
                OnPropertyChanged("Name");
            }
        }

        protected bool _isExpaned = false;
        public bool IsExpanded
        {
            get
            {
                return _isExpaned;
            }
            set
            {
                _isExpaned = value;
                this.OnPropertyChanged("IsExpanded");
            }
        }

        public string Message
        {
            get;
            set;
        }

        protected int _testNo = 0;
        public int TestNo
        {
            get
            {
                return _testNo;
            }
            set
            {
                _testNo = value;
            }
        }

        #endregion

        // ----------------------------------------
        // INotifyPropertyChangedインターフェース
        // ----------------------------------------
        #region INotifyPropertyChanged InterFace

        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        // ----------------------------------------
        // IUTTestインターフェース
        // ----------------------------------------
        #region IUTTestInterFace

        protected UTResultEnum _testResult = UTResultEnum.Non;
        public UTResultEnum TestResult
        {
            get
            {
                return _testResult;
            }
            set
            {
                _testResult = value;
                this.OnPropertyChanged("TestResult");
            }
        }

        public int TestCount
        {
            get
            {
                int sum = 0;
                foreach (var child in _children)
                {
                    sum += child.TestCount;
                }
                return sum;
            }
        }

        public List<UTTest> GetTestList()
        {
            var list = new List<UTTest>();

            foreach (var group in _children)
            {
                list.AddRange(group.GetTestList());
            }

            return list;
        }

        public void ExecTest()
        {
            foreach (var child in _children)
            {
                child.ExecTest();
            }

            if (_children.Any((x) => x.TestResult == UTResultEnum.NG))
            {
                TestResult = UTResultEnum.NG;
            }
            else
            {
                TestResult = UTResultEnum.OK;
            }
        }

        public void ClearResult()
        {
            foreach (var child in _children)
            {
                child.ClearResult();
            }
            TestResult = UTResultEnum.Non;
        }

        protected bool _isSelected = false;
        public bool IsSelected
        {
            get
            {
                return _isSelected;
            }


            set
            {
                _isSelected = value;
                this.OnPropertyChanged("IsSelected");
            }
        }

        #endregion

        // ----------------------------------------
        // コンストラクタ
        // ----------------------------------------
        #region Constructor

        public UTGroups()
        {
            //_children[0].PropertyChanged += new PropertyChangedEventHandler(UTGroup_PropertyChanged);
        }

        #endregion

        // ----------------------------------------
        // メソッド
        // ----------------------------------------
        #region Methods

        public IUTTest SearchSelectedItem()
        {
            if (IsSelected)
            {
                return this;
            }

            foreach (var group in _children)
            {
                var item = group.SearchSelectedItem();
                if (item != null)
                {
                    return item;
                }
            }

            return null;
        }

        #endregion
    }
}
