﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using System.Windows;
using System.Windows.Controls;
namespace CTester.Setting
{
    public class WindowLayout
    {
        /// <summary>
        /// シリアライズデータ
        /// </summary>
        [Serializable, XmlType("WindowLayout")]
        public class SerializeData
        {
            public System.Windows.WindowState WindowState { get; set; }
            public double Left { get; set; }
            public double Top { get; set; }
            public double Width { get; set; }
            public double Height { get; set; }

            public SerializeData()
            {
            }
        }

        System.Windows.WindowState _windowState = System.Windows.WindowState.Normal;
        public System.Windows.WindowState WindowState
        {
            get
            {
                return _windowState;
            }
            set
            {
                _windowState = value;
            }
        }
        public double Left { get; set; }
        public double Top { get; set; }
        public double Width { get; set; }
        public double Height { get; set; }

        //public double MainGridColumn1Width { get; set; }

        public WindowLayout()
        {
            WindowState = System.Windows.WindowState.Normal;
            Left = 50;
            Left = 50;
            Width = 1000;
            Height = 800;
        }

        public WindowLayout(System.Windows.Window window)
        {
            WindowState = window.WindowState;
            Left = window.Left;
            Top = window.Top;
            Width = window.Width;
            Height = window.Height;
        }

        public SerializeData GetSerializeData()
        {
            var data = new SerializeData();
            data.WindowState = WindowState;
            data.Left = Left;
            data.Top = Top;
            data.Width = Width;
            data.Height = Height;

            return data;
        }

        public void LoadSerializeData(SerializeData data)
        {
            if (data == null)
            {
                return;
            }

            WindowState = data.WindowState;
            Left = data.Left;
            Top = data.Top;
            Width = data.Width;
            Height = data.Height;
        }
    }
}
