﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
namespace CTester.Setting
{
    public class EmuButtonSetting
    {
        public string Name { get; set; }
        public EmuEventSetting ButtonOn { get; set; }
        public EmuEventSetting ButtonOff { get; set; }

        private Size _size = new Size(40, 24);
        public Size Size 
        { 
            get
            {
                return _size;
            }
            set
            {
                _size = value;
            }
        }

        public Point _position = new Point(10,10);
        public Point Position
        {
            get
            {
                return _position;
            }
            set
            {
                _position = value;
            }
        }

        public EmuButtonSetting()
        {
            Name = "新しいボタン";
            ButtonOn = new EmuEventSetting();
            ButtonOff = new EmuEventSetting();
        }

        public EmuButtonSetting(string name, EmuEventSetting buttonOn, EmuEventSetting buttonOff)
        {
            Name = name;
            ButtonOn = buttonOn;
            ButtonOff = buttonOff;
        }
    }

}
