﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
//using System.Windows.Shapes;
using System.IO;
using Microsoft.Win32;
using Utility;

namespace CTester.NewProject
{
    /// <summary>
    /// PageSource.xaml の相互作用ロジック
    /// </summary>
    public partial class PageSource : PageFunction<WizardResult>
    {
        private NewProjectInfo _newProjectInfo;

        public PageSource(NewProjectInfo newProjectInfo)
        {
            InitializeComponent();

            _newProjectInfo = newProjectInfo;
        }

        /// <summary>
        /// あとで設定
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void buttonAfter_Click(object sender, RoutedEventArgs e)
        {
            _newProjectInfo.SourcePath = string.Empty;
            OnReturn(new ReturnEventArgs<WizardResult>(WizardResult.Finished));
        }

        /// <summary>
        /// 完了
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void buttonFinish_Click(object sender, RoutedEventArgs e)
        {
            var path = textBoxSource.Text;

            var exteition = Path.GetExtension(path);
            if (exteition != "dll")
            {
                MessageBox.Show("指定ファイルが不正です。", "エラー", MessageBoxButton.OK);
                return;
            }

            _newProjectInfo.SourcePath = path;
            OnReturn(new ReturnEventArgs<WizardResult>(WizardResult.Finished));
        }

        /// <summary>
        /// キャンセル
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void buttonCancel_Click(object sender, RoutedEventArgs e)
        {
            OnReturn(new ReturnEventArgs<WizardResult>(WizardResult.Canceled));
        }

        private void buttonReference_Click(object sender, RoutedEventArgs e)
        {
            var dlg = new OpenFileDialog();

            dlg.Filter = "ソースDLL(*.dll)|*.dll";
            dlg.CheckFileExists = true;
            dlg.Multiselect = false;
            dlg.Title = "DLLファイルを指定してください。";
            if (dlg.ShowDialog() == true)
            {
                textBoxSource.Text = dlg.FileName;
            }

        }
    }
}
