﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

namespace CTester
{
    /// <summary>
    /// テストソースインターフェース
    /// </summary>
    public interface ITesterSource
    {
        int UT_GetTestCount();
        int UT_GetTestResult(int iTestNo);
        IntPtr UT_GetTestMessage(int iTestNo);
        int UT_GetTestMessageLength();
        IntPtr UT_GetTestFileName(int iTestNo);
        int UT_GetTestFileNameLength();
        IntPtr UT_GetTestFuncName(int iTestNo);
        int UT_GetTestFuncNameLength();
        int UT_ExecTest(int iTestNo);
        void UT_ClearResultAll();

        //int TD_GetDriverCount();
        //IntPtr TD_GetDriverFileName(int iDriverNo);
        //int TD_GetDriverFileNameLength(int iDriverNo);
        //IntPtr TD_GetDriverFuncName(int iDriverNo);
        //int TD_GetDriverFuncNameLength(int iDriverNo);
        //IntPtr TD_GetDriverMessage(int iDriverNo);
        //int TD_GetDriverMessageLength();
        //int TD_ExecDriver(int iDriverNo, int iParam, char[] inExData,int inExDataSize);
    }

    public class ExParam
    {
        public byte[] data = new byte[100];
        public int size = 100;
    }

    /// <summary>
    /// テストソースの拡張メソッド
    /// </summary>
    public static class TesterSourceExtensions
    {
        //public static int ExecTDDriver(
        //    this ITesterSource source,
        //    int driverNo,
        //    int iParam,
        //    string inExData,
        //    out string outExData)
        //{

        //    int ret = source.TD_ExecDriver(driverNo, iParam, inExData.ToArray<char>(), inExData.Length);
        //    outExData = GetTDMessage(source,driverNo);
            
        //    return ret;
        //}

        //public static string GetTDMessage(this ITesterSource source, int driverNo)
        //{
        //    return GetUTStringSub(
        //                source.TD_GetDriverMessage(driverNo),
        //                source.TD_GetDriverMessageLength());
        //}

        public static string GetUTMessage(this ITesterSource source,int testNo)
        {
            return GetUTStringSub(
                        source.UT_GetTestMessage(testNo),
                        source.UT_GetTestMessageLength());
        }


        public static string GetUTFileName(this ITesterSource source, int testNo)
        {
            return GetUTStringSub(
                        source.UT_GetTestFileName(testNo),
                        source.UT_GetTestFileNameLength());
        }

        public static string GetUTFuncName(this ITesterSource source, int testNo)
        {
            return GetUTStringSub(
                        source.UT_GetTestFuncName(testNo),
                        source.UT_GetTestFuncNameLength());
        }

        private static string GetUTStringSub(IntPtr ptr, int length)
        {
            Encoding sjisEcn = Encoding.GetEncoding("Shift_JIS");
            byte[] byteName;
            string strFileName;
            int strLength = 0;

            byteName = new byte[length];
            Marshal.Copy(ptr, byteName, 0, length);

            strLength = length;
            for (int i = 0; i < byteName.Length; i++)
            {
                if (byteName[i] == 0x00)
                {
                    strLength = i;
                    break;
                }
            }
            strFileName = sjisEcn.GetString(byteName, 0, strLength);

            return strFileName;
        }

    }
}
