﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.Text.RegularExpressions;
using lib2ch.Data;

namespace lib2ch.IO
{
    class File
    {
        Encoding _Type;
        string _NewLine;
        string _UserAgent;
        public File()
        {
            _Type = Encoding.GetEncoding("Shift_JIS");
            //2chが使う改行コード windowsは\r\n
            _NewLine = "\n";
            //ユーザーエージェントの指定
            _UserAgent = "Monazilla/1.00(cs2ch/lib2ch)";
        }
        public Encoding Type
        {
            get { return _Type; }
            set { _Type = value; }
        }
        public FileResult LocalReader(string Path)
        {
            try
            {
                FileResult fileResult = new FileResult();
                string line = "";
                using (StreamReader sr = new StreamReader(Path, _Type))
                {
                    while ((line = sr.ReadLine()) != null)
                    {
                        fileResult.Line.Add(line);
                    }
                }
                return fileResult;
            }
            catch
            {
                return null;
            }
        }
        public FileResult UrlReader(string UrlPath,int Range,string ETag)
        {
            try
            {
                return UrlReaderRange(UrlPath, Range,ETag);              
            }
            catch
            {
                return null;
            }
        }
        //WebRequestを使ったダウンロード(差分対応)
        private FileResult UrlReaderRange(string UrlPath, int Range, string ETag)
        {
            //WebRequestの作成
            //HttpWebRequestへキャストしないと一部項目をいじれない
            HttpWebRequest webRequest = (HttpWebRequest)WebRequest.Create(UrlPath);
            webRequest.UserAgent = _UserAgent;
            if (Range > -1)
                webRequest.AddRange(Range);
            if (ETag != "")
            {
                if (Range > 0)
                    webRequest.Headers.Add("If-Range", ETag);
                else
                    webRequest.Headers.Add("If-None-Match", ETag);
            }
            webRequest.KeepAlive = false;
            webRequest.Headers.Add("Pragma", "no-cache");
            webRequest.Headers.Add("Cache-Control", "no-cache");
            HttpWebResponse webResponse = null;
            FileResult fileResult = new FileResult();
            //サーバーからの応答を受信するためのWebResponseを取得
            try
            {
                webResponse = (HttpWebResponse)webRequest.GetResponse();
            }
            catch (WebException ee)
            {
                //304などはこちらで処理
                if (ee.Status == WebExceptionStatus.ProtocolError)
                {
                    HttpWebResponse errres = (HttpWebResponse)ee.Response;
                    fileResult.StatusCode = errres.StatusCode.ToString();
                    fileResult.ErrorCode = errres.StatusDescription.ToString();
                }
                else
                {
                    fileResult.ErrorCode += ee.Message.ToString();
                }
                return fileResult;
            }
            //200などはこちらへ
            //entityTagを保存
            fileResult.EntityTag = webResponse.GetResponseHeader("ETag");
            fileResult.StatusCode = webResponse.StatusCode.ToString();
            //応答データを受信するためのStreamを取得
            using (Stream stream = webResponse.GetResponseStream())
            {
                using (StreamReader StreamReader = new StreamReader(stream, _Type))
                {
                    string line = "";
                    while ((line = StreamReader.ReadLine()) != null)
                    {
                        fileResult.Line.Add(line);
                    }
                }
            }
            return fileResult;
        }

        public int LocalWriter(string FilePath, string FileName, List<string> WriteData,bool Option)
        {
            if (!Directory.Exists(FilePath))
                Directory.CreateDirectory(FilePath);
            try
            {
                using (StreamWriter sw = new StreamWriter(FilePath + FileName, Option, _Type))
                {
                    //改行コードを2ch仕様に変更
                    //これを行わないとローカル側と
                    //サーバー側のサイズが合わなくなる
                    sw.NewLine = _NewLine;
                    foreach (string line in WriteData)
                    {
                        sw.WriteLine(line);
                    }
                }
                return 0;
            }
            catch
            {
                return -1;
            }
        }
    }
}