﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using lib2ch.IO;

namespace lib2ch.Data
{
    /// <summary>
    /// スキンデータ保持クラス
    /// </summary>
    public class Skin
    {
        string _DatHeader;
        string _DatFooter;
        const string Path = "./Skin/";
        const string DatHeaderFileName = "DatHeader.html";
        const string DatFooterFileName = "DatFooter.html";
        string _SystemPath;
        /// <summary>
        /// 絶対パスを指定してください。
        /// </summary>
        /// <param name="SystemPath"></param>
        public Skin(string SystemPath)
        {
            _SystemPath = SystemPath;
            //Load関数がよばれなくても一応動くように
            //デフォルトをセット・・・
            DatHeaderDefaultSet();
            DatFooterDefaultSet();
        }
        /// <summary>
        /// Dat用ヘッダー
        /// </summary>
        public string DatHeader
        {
            get { return _DatHeader; }
        }
        /// <summary>
        /// Dat用フッター
        /// </summary>
        public string DatFooter
        {
            get { return _DatFooter; }
        }
        /// <summary>
        /// ヘッダーおよびフッター読み込み
        /// </summary>
        public void Load()
        {
            _DatHeader = load(Path + DatHeaderFileName);
            _DatFooter = load(Path + DatFooterFileName);
            //ヘッダーが読み込め無かった場合はデフォルトのヘッダーをセット
            if (_DatHeader == "")
            {
                DatHeaderDefaultSet();
            }
            else
            {
                //<SKINPATH/>と絶対パスを入れ替え
                //手抜きして正規表現を使わない
                _DatHeader = _DatHeader.Replace("<SKINPATH/>", _SystemPath);
            }
            //フッターが読み込め無かった場合はデフォルトのフッターをセット
            if (_DatFooter == "")
            {
                DatFooterDefaultSet();
            }
        }
        //読み込み
        //いい名前が浮かばなかったので適当・・・
        private string load(string FileName)
        {
            string res = "";
            File file = new File();
            FileResult fileResult = file.LocalReader(FileName);
            //正規表現のファイル有無
            if (fileResult == null) return res;
            foreach(string Line in fileResult.Line)
            {
                res += Line + Environment.NewLine;
            }
            return res;
        }
        //デフォルトヘッダー
        private void DatHeaderDefaultSet()
        {
            _DatHeader = "<!-- saved from url=(0014)about:internet -->\r\n" +
                         "<html>\r\n<head>\r\n</head>\r\n" +
                         "<body>\r\n<basefont face='ＭＳ Ｐゴシック'>\r\n<dl>\r\n";
        }
        //デフォルトフッター
        private void DatFooterDefaultSet()
        {
            _DatFooter = "</dl></body></html>";
        }
    }
}
