﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Xml.Serialization;
using lib2ch.Model;
using lib2ch.Data;
using System.Runtime.InteropServices;

namespace cs2ch
{
    public partial class Form1 : Form
    {
        const string FormSettingFileName = @"./FormSetting.xml";
        const string RegexTextFileName = @"./ReplaceText.txt";
        Subject _Subject;
        ThreadDat _ThreadDat;
        Replacer _Replacer;
        Skin _Skin;
        public Form1()
        {
            InitializeComponent();
        }

        #region システムメニュー関連

        [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
        private struct MENUITEMINFO
        {
            public uint cbSize;
            public uint fMask;
            public uint fType;
            public uint fState;
            public uint wID;
            public IntPtr hSubMenu;
            public IntPtr hbmpChecked;
            public IntPtr hbmpUnchecked;
            public IntPtr dwItemData;
            public string dwTypeData;
            public uint cch;
            public IntPtr hbmpItem;
        }

        [DllImport("user32", ExactSpelling = true)]
        private static extern IntPtr GetSystemMenu(IntPtr hWnd, bool bRevert);
        [DllImport("user32", CharSet = CharSet.Auto)]
        private static extern bool InsertMenuItem(IntPtr hMenu, uint uItem, bool fByPosition, ref MENUITEMINFO lpmii);

        private const uint MENU_VIEW = 0x9999;
        private const uint MFT_SEPARATOR = 0x00000800;
        private const uint MIIM_FTYPE = 0x00000100;
        private const uint MIIM_STRING = 0x00000040;
        private const uint MIIM_ID = 0x00000002;

        protected override void OnCreateControl()
        {
            base.OnCreateControl();

            //システムメニューのハンドル取得
            IntPtr hSysMenu = GetSystemMenu(this.Handle, false);

            //セパレーターの挿入
            MENUITEMINFO item1 = new MENUITEMINFO();
            item1.cbSize = (uint)Marshal.SizeOf(item1);
            item1.fMask = MIIM_FTYPE;
            item1.fType = MFT_SEPARATOR;
            InsertMenuItem(hSysMenu, 5, true, ref item1);

            //メニュー項目の挿入
            MENUITEMINFO item2 = new MENUITEMINFO();
            item2.cbSize = (uint)Marshal.SizeOf(item2);
            item2.fMask = MIIM_STRING | MIIM_ID;
            item2.wID = MENU_VIEW;
            item2.dwTypeData = "メニューの表示(&V)";
            InsertMenuItem(hSysMenu, 6, true, ref item2);
        }

        protected override void WndProc(ref Message m)
        {
            base.WndProc(ref m);
            if (m.Msg == 0x0112)        // WM_SYSCOMMAND
            {
                if ((m.WParam.ToInt32() & 0xfffF) == MENU_VIEW)
                {
                    menuStrip1.Visible = !menuStrip1.Visible;
                }
            }
        }
        #endregion

        private void Form1_Load(object sender, EventArgs e)
        {
            //プログラム初回のみ必要なコードですが一応
            toolStripComboBox1.SelectedIndex = 0;
            toolStripComboBox2.SelectedIndex = 0;

            FormSettingRestore();

            #region BBSメニュー
            BbsMenu _BbsMenu = new BbsMenu();
            List<BbsMenuItem> _BbsMenuList = _BbsMenu.GetMenuList();
            foreach (BbsMenuItem Item in _BbsMenuList)
            {
                TreeNode ChildNode = new TreeNode();
                ChildNode.Name = Item.Name;
                ChildNode.Text = Item.Name;
                ChildNode.Tag = Item;
                TreeNode[] node = treeView1.Nodes.Find(Item.ParentName, false);
                if (node.Length == 0)
                {
                    TreeNode Parent = new TreeNode();
                    Parent.Name = Item.ParentName;
                    Parent.Text = Parent.Name;
                    Parent.Nodes.Add(ChildNode);
                    treeView1.Nodes.Add(Parent);
                }
                else
                {
                    node[0].Nodes.Add(ChildNode);
                }
            }
            #endregion
            _Subject = new Subject();
            _ThreadDat = new ThreadDat();
            //正規表現読み込み
            _Replacer = new Replacer();
            _Replacer.Load(RegexTextFileName);
            //スキンの読み込み
            _Skin = new Skin(Environment.CurrentDirectory + "\\Skin\\");
            _Skin.Load();
        }

        #region FormSetting.xml関連
        //FormSetting.xml書き込み
        private int FormSettingSerialize(FormSetting FormSetting)
        {
            try
            {
                XmlSerializer serializer = new XmlSerializer(typeof(FormSetting));
                FileStream fileStream = new FileStream(FormSettingFileName, FileMode.Create);
                serializer.Serialize(fileStream, FormSetting);
                fileStream.Close();
                return 0;
            }
            catch
            {
                return -1;
            }
        }
        //FormSetting.xmlへ保存する内容のセット
        private void FormSettingSave()
        {
            FormSetting FormSetting = new FormSetting();
            FormSetting.FormLocation = this.Location;
            FormSetting.FormSize = this.Size;
            FormSetting.FormState = this.WindowState;
            FormSetting.toolStrip1Visible = toolStrip1.Visible;
            FormSetting.toolStrip2Visible = toolStrip2.Visible;
            FormSetting.toolStrip3Visible = toolStrip3.Visible;
            FormSetting.pain1Visible = splitContainer1.Panel1Collapsed;
            FormSetting.pain2Visible = splitContainer2.Panel1Collapsed;
            FormSetting.pain3Visible = splitContainer2.Panel2Collapsed;
            FormSetting.splitContainer1Orientation = splitContainer1.Orientation;
            FormSetting.splitContainer1SplitterDistance = splitContainer1.SplitterDistance;
            FormSetting.splitContainer2Orientation = splitContainer2.Orientation;
            FormSetting.splitContainer2SplitterDistance = splitContainer2.SplitterDistance;
            FormSetting.flowLayoutPanelEx1Dock = flowLayoutPanelEx1.Dock;
            FormSetting.flowLayoutPanelEx2Dock = flowLayoutPanelEx2.Dock;
            FormSetting.toolStripComboBox1SelectedIndex = toolStripComboBox1.SelectedIndex;
            FormSetting.toolStripComboBox2SelectedIndex = toolStripComboBox2.SelectedIndex;
            if (FormSettingSerialize(FormSetting) != 0)
                MessageBox.Show(FormSettingFileName + "の保存に失敗しました。");
        }
        //FormSetting.xml読み込み
        private FormSetting FormSettingDeserialize()
        {
            try
            {
                XmlSerializer serializer = new XmlSerializer(typeof(FormSetting));
                FileStream fileStream = new FileStream(FormSettingFileName, FileMode.Open);
                FormSetting FormSetting = (FormSetting)serializer.Deserialize(fileStream);
                fileStream.Close();
                return FormSetting;
            }
            catch
            {
                return null;
            }
        }
        //FormSetting.xmlから読み込んだ設定を元に復元
        private void FormSettingRestore()
        {
            FormSetting FormSetting = FormSettingDeserialize();
            //FormSetting.xmlが読み込みできたら復元処理を行う。
            //読み込みできない場合はデフォルトのまま
            if (FormSetting != null)
            {
                this.Location = FormSetting.FormLocation;
                this.Size = FormSetting.FormSize;
                this.WindowState = FormSetting.FormState;
                toolStripMenuItem2.Checked = FormSetting.toolStrip1Visible;
                toolStrip1.Visible = FormSetting.toolStrip1Visible;
                toolStripMenuItem3.Checked = FormSetting.toolStrip2Visible;
                toolStrip2.Visible = FormSetting.toolStrip2Visible;
                toolStripMenuItem4.Checked = FormSetting.toolStrip3Visible;
                toolStrip3.Visible = FormSetting.toolStrip3Visible;
                splitContainer1.Panel1Collapsed = FormSetting.pain1Visible;
                splitContainer2.Panel1Collapsed = FormSetting.pain2Visible;
                splitContainer2.Panel2Collapsed = FormSetting.pain3Visible;
                splitContainer1.Orientation = FormSetting.splitContainer1Orientation;
                splitContainer1.SplitterDistance = FormSetting.splitContainer1SplitterDistance;
                splitContainer2.Orientation = FormSetting.splitContainer2Orientation;
                splitContainer2.SplitterDistance = FormSetting.splitContainer2SplitterDistance;
                flowLayoutPanelEx1.Dock = FormSetting.flowLayoutPanelEx1Dock;
                flowLayoutPanelEx2.Dock = FormSetting.flowLayoutPanelEx2Dock;
                toolStripComboBox1.SelectedIndex = FormSetting.toolStripComboBox1SelectedIndex;
                toolStripComboBox2.SelectedIndex = FormSetting.toolStripComboBox2SelectedIndex;
            }
        }
        #endregion

        #region ツールバー関連
        private void toolStripMenuItem2_Click(object sender, EventArgs e)
        {
            toolStrip1.Visible = !toolStrip1.Visible;
        }

        private void toolStripMenuItem3_Click(object sender, EventArgs e)
        {
            toolStrip2.Visible = !toolStrip2.Visible;
        }

        private void toolStripMenuItem4_Click(object sender, EventArgs e)
        {
            toolStrip3.Visible = !toolStrip3.Visible;
        }
        #endregion

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            //Formを閉じる際にWindowStateをNormalに戻す
            this.WindowState = FormWindowState.Normal;
            FormSettingSave();
        }

        #region ペイン表示関連
        private void toolStripButton2_Click(object sender, EventArgs e)
        {
            splitContainer1.Panel1Collapsed = !splitContainer1.Panel1Collapsed;
        }

        private void toolStripButton3_Click(object sender, EventArgs e)
        {
            splitContainer2.Panel1Collapsed = !splitContainer2.Panel1Collapsed;
        }

        private void toolStripButton4_Click(object sender, EventArgs e)
        {
            splitContainer2.Panel2Collapsed = !splitContainer2.Panel2Collapsed;
        }
        #endregion
        #region ペイン分割切替関連
        private void toolStripButton5_Click(object sender, EventArgs e)
        {
            if (splitContainer1.Orientation == Orientation.Horizontal)
                splitContainer1.Orientation = Orientation.Vertical;
            else
                splitContainer1.Orientation = Orientation.Horizontal;
        }

        private void toolStripButton6_Click(object sender, EventArgs e)
        {
            if (splitContainer2.Orientation == Orientation.Horizontal)
                splitContainer2.Orientation = Orientation.Vertical;
            else
                splitContainer2.Orientation = Orientation.Horizontal;
        }
        #endregion

        #region タブ位置変更
        private void toolStripComboBox1_DropDownClosed(object sender, EventArgs e)
        {
            switch (toolStripComboBox1.SelectedIndex)
            {
                case 1:
                    flowLayoutPanelEx1.Dock = DockStyle.Bottom;
                    break;
                case 2:
                    flowLayoutPanelEx1.Dock = DockStyle.Left;
                    break;
                case 3:
                    flowLayoutPanelEx1.Dock = DockStyle.Right;
                    break;
                default:
                    flowLayoutPanelEx1.Dock = DockStyle.Top;
                    break;
            }
        }

        private void toolStripComboBox2_DropDownClosed(object sender, EventArgs e)
        {
            switch (toolStripComboBox2.SelectedIndex)
            {
                case 1:
                    flowLayoutPanelEx2.Dock = DockStyle.Bottom;
                    break;
                case 2:
                    flowLayoutPanelEx2.Dock = DockStyle.Left;
                    break;
                case 3:
                    flowLayoutPanelEx2.Dock = DockStyle.Right;
                    break;
                default:
                    flowLayoutPanelEx2.Dock = DockStyle.Top;
                    break;
            }
        }
        #endregion

        #region 板覧アイテム選択時のスレ覧へ項目追加
        private void treeView1_AfterSelect(object sender, TreeViewEventArgs e)
        {
            if (e.Node.Tag != null)
            {
                ThreadListAdd((BbsMenuItem)e.Node.Tag);
            }
        }
        private void ThreadListAdd(BbsMenuItem BbsMenuItem)
        {
            //追加予定項目の重複チェック
            Control[] chk = flowLayoutPanelEx1.Controls.Find(BbsMenuItem.Name, false);
            if (chk.Length > 0) return;
            //重複ない場合の追加処理
            ButtonEx button = new ButtonEx();   //タブ用ボタン
            ListViewEx listView = new ListViewEx(); //スレ覧のリスト用
            button.Name = BbsMenuItem.Name;
            button.Text = BbsMenuItem.Name;
            button.Tag = listView;
            button.Click += new EventHandler(ThreadListButton_Click);
            button.MouseDown += new MouseEventHandler(ThreadListButton_MouseClick);
            flowLayoutPanelEx1.Controls.Add(button);
            Application.DoEvents();
            panel2.Controls.Add(listView);
            listView.ItemSet(_Subject.Get(BbsMenuItem));
            listView.BringToFront();
            listView.ItemActivate += new EventHandler(listView_ItemActivate);
        }
        void ThreadListButton_Click(object sender, EventArgs e)
        {
            ButtonEx button = (ButtonEx)sender;
            ListViewEx listView = (ListViewEx)button.Tag;
            listView.BringToFront();
        }
        void ThreadListButton_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                ButtonEx button = (ButtonEx)sender;
                ListViewEx listView = (ListViewEx)button.Tag;
                SubjectList SubjectList = _Subject.ReLoad((SubjectList)listView.Tag);
                if (SubjectList == null)
                {
                    toolStripStatusLabel1.Text = "更新無し";
                    return;
                }
                listView.Items.Clear();
                listView.ItemSet(SubjectList);
                toolStripStatusLabel1.Text = "再取得しました";
            }
        }
        #endregion
        #region スレッド一覧リストアイテム選択時のスレッドへの項目追加
        void listView_ItemActivate(object sender, EventArgs e)
        {
            ListViewEx listView = (ListViewEx)sender;
            ThreadViewAdd((SubjectData)listView.SelectedItems[0].Tag);
        }
        private void ThreadViewAdd(SubjectData SubjectData)
        {
            //追加予定項目の重複チェック
            Control[] chk = flowLayoutPanelEx2.Controls.Find(SubjectData.FileName, false);
            if (chk.Length > 0) return;
            ButtonEx button = new ButtonEx();
            WebBrowserEx webBrowser = new WebBrowserEx(_Replacer,_Skin);
            button.Name = SubjectData.FileName;
            button.Text = SubjectData.Title;
            button.Tag = webBrowser;
            button.Click += new EventHandler(ThreadViewButton_Click);
            button.MouseDown += new MouseEventHandler(ThreadViewButton_MouseClick);
            flowLayoutPanelEx2.Controls.Add(button);
            Application.DoEvents();
            panel3.Controls.Add(webBrowser);
            webBrowser.ItemSet(_ThreadDat.Get(SubjectData));
        }

        //スレッドタブボタンクリック処理
        void ThreadViewButton_Click(object sender, EventArgs e)
        {
            ButtonEx button = (ButtonEx)sender;
            WebBrowserEx webBrowser = (WebBrowserEx)button.Tag;
            webBrowser.BringToFront();
        }
        void ThreadViewButton_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                ButtonEx button = (ButtonEx)sender;
                WebBrowserEx webBrowser = (WebBrowserEx)button.Tag;
                Dat Dat = _ThreadDat.RangeRead((Dat)webBrowser.Tag);
                if (Dat == null)
                {
                    toolStripStatusLabel1.Text = "新しい書き込み無し";
                    return;
                }
                webBrowser.ItemSet(Dat);
                toolStripStatusLabel1.Text = "新しい書き込みあったよ";
            }
        }
        #endregion
    }
}
