﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace Tetris
{
    class Screen
    {
        public Block[] Block;
        public int[,] borad;
        public Screen()
        {

            #region ボード初期化
            borad = new int[12, 25];
            for (int x = 0; x < 12; x++)
            {
                for (int y = 0; y < 25; y++)
                {
                    if (x == 0 || x == 11 || y == 0)
                    {
                        borad[x, y] = 1;
                    }
                    else
                    {
                        borad[x, y] = 0;
                    }
                }
            }
            #endregion
            #region ブロック初期化
            Block = new Block[8];
            for (int i = 0; i < 8; i++)
            {
                Block[i] = new Block();
            }
            Block[0].rotate = 1;
            Block[0].Position[0].x = 0;
            Block[0].Position[0].y = 0;
            Block[0].Position[1].x = 0;
            Block[0].Position[1].y = 0;
            Block[0].Position[2].x = 0;
            Block[0].Position[2].y = 0;

            Block[1].rotate = 2;
            Block[1].Position[0].x = 0;
            Block[1].Position[0].y = -1;
            Block[1].Position[1].x = 0;
            Block[1].Position[1].y = 1;
            Block[1].Position[2].x = 0;
            Block[1].Position[2].y = 2;

            Block[2].rotate = 4;
            Block[2].Position[0].x = 0;
            Block[2].Position[0].y = -1;
            Block[2].Position[1].x = 0;
            Block[2].Position[1].y = 1;
            Block[2].Position[2].x = 1;
            Block[2].Position[2].y = 1;

            Block[3].rotate = 4;
            Block[3].Position[0].x = 0;
            Block[3].Position[0].y = -1;
            Block[3].Position[1].x = 0;
            Block[3].Position[1].y = 1;
            Block[3].Position[2].x = -1;
            Block[3].Position[2].y = 1;

            Block[4].rotate = 2;
            Block[4].Position[0].x = 0;
            Block[4].Position[0].y = -1;
            Block[4].Position[1].x = 1;
            Block[4].Position[1].y = 0;
            Block[4].Position[2].x = 1;
            Block[4].Position[2].y = 1;

            Block[5].rotate = 2;
            Block[5].Position[0].x = 0;
            Block[5].Position[0].y = -1;
            Block[5].Position[1].x = -1;
            Block[5].Position[1].y = 0;
            Block[5].Position[2].x = -1;
            Block[5].Position[2].y = 1;

            Block[6].rotate = 1;
            Block[6].Position[0].x = 0;
            Block[6].Position[0].y = 1;
            Block[6].Position[1].x = 1;
            Block[6].Position[1].y = 0;
            Block[6].Position[2].x = 1;
            Block[6].Position[2].y = 1;

            Block[7].rotate = 4;
            Block[7].Position[0].x = 0;
            Block[7].Position[0].y = -1;
            Block[7].Position[1].x = 1;
            Block[7].Position[1].y = 0;
            Block[7].Position[2].x = -1;
            Block[7].Position[2].y = 0;
            #endregion
        }
        public bool PutBlock(Status Status, bool action)
        {
            if (borad[Status.x, Status.y] != 0)
            {
                return false;
            }
            if (action)
            {
                borad[Status.x, Status.y] = Status.type;
            }
            for (int i = 0; i < 3; i++)
            {
                int dx = Block[Status.type].Position[i].x;
                int dy = Block[Status.type].Position[i].y;
                int r = Status.rotate % Block[Status.type].rotate;
                for(int j= 0;j<r;j++)
                {
                    int nx = dx, ny = dy;
                    dx = ny;
                    dy = -nx;
                }
                if (borad[Status.x + dx, Status.y + dy] != 0)
                {
                    return false;
                }
                if (action)
                {
                    borad[Status.x + dx, Status.y + dy] = Status.type;
                }
            }
            if (!action)
            {
                PutBlock(Status, true);
            }
            return true;
        }
        public bool DelBlock(Status Status)
        {
            borad[Status.x, Status.y] = 0;
            for (int i = 0; i < 3; i++)
            {
                int dx = Block[Status.type].Position[i].x;
                int dy = Block[Status.type].Position[i].y;
                int r = Status.rotate % Block[Status.type].rotate;
                for (int j = 0; j < r; j++)
                {
                    int nx = dx, ny = dy;
                    dx = ny;
                    dy = -nx;
                }
                borad[Status.x + dx, Status.y + dy] = 0;
            }
            return true;
        }
    }
}
