﻿using System;
using System.ComponentModel;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using lib2ch.Data;

namespace cs2ch
{
    class WebBrowserEx : WebBrowser
    {
        Replacer _Replacer;
        Skin _Skin;
        public string _Title;
        int DocumentCompletedFlag;
        int AddFlag;
        Dat _Dat;
        int index;
        public WebBrowserEx(Replacer Replacer,Skin Skin)
        {
            _Replacer = Replacer;
            _Skin = Skin;
            _Dat = null;
            index = 1;
            DocumentCompletedFlag = 0;
            AddFlag = 0;
            this.Dock = DockStyle.Fill;
            this.DocumentCompleted += new WebBrowserDocumentCompletedEventHandler(WebBrowserEx_DocumentCompleted);
            this.DocumentText = _Skin.DatHeader + _Skin.DatFooter;
        }

        void WebBrowserEx_DocumentCompleted(object sender, WebBrowserDocumentCompletedEventArgs e)
        {
            if(_Dat != null)
                HtmlElementAdd();
            DocumentCompletedFlag = 1;
            this.Document.Click += new HtmlElementEventHandler(WebBrowserExDocument_Click);
            this.Navigating += new WebBrowserNavigatingEventHandler(WebBrowserEx_Navigating);
        }

        void WebBrowserEx_Navigating(object sender, WebBrowserNavigatingEventArgs e)
        {
            e.Cancel = true;
        }

        public void ItemSet(Dat Dat)
        {
            if (Dat == null)
            {
                this.Document.Write("ぬるぽ");
                return;
            }
            if (this.Tag == null)
            {
                _Title = Dat.Res[0].Option;
                _Dat = Dat;
                this.Tag = Dat;
            }
            else
            {
                _Dat = Dat;
                AddFlag = 1;
            }
            if (DocumentCompletedFlag == 1)
                HtmlElementAdd();
        }

        private void HtmlElementAdd()
        {
            HtmlDocument doc = this.Document;
            string text = "";
            Dat Dat = (Dat)this.Tag;
            foreach (DatRes Res in _Dat.Res)
            {
                //dtタグ(2chの場合レス番号や名前などの行)
                HtmlElement elemdt = doc.CreateElement("dt");
                text = index.ToString() + " 名前:<b> ";
                text += Res.Name + " </b>[";
                text += Res.Mail + "]";
                text += Res.Id;
                text += Environment.NewLine;
                elemdt.InnerHtml = text;
                doc.Body.FirstChild.FirstChild.AppendChild(elemdt);

                //ddタグ(2chの場合レス本文)
                HtmlElement elemdd = doc.CreateElement("dd");
                text = _Replacer.Replace(Res.Data) + "<br><br>";
                text += Environment.NewLine;
                elemdd.InnerHtml = text;
                doc.Body.FirstChild.FirstChild.AppendChild(elemdd);
                index++;
            }
            if (AddFlag == 1)
            {
                foreach (DatRes Res in _Dat.Res)
                {
                    Dat.Res.Add(Res);
                }
            }
            _Dat = null;
            this.BringToFront();
        }
        public string Title
        {
            get { return _Title; }
        }

        void WebBrowserExDocument_Click(object sender, HtmlElementEventArgs e)
        {
            HtmlElement clickedElement = this.Document.GetElementFromPoint(e.MousePosition);
            string link = null;
            if (clickedElement.TagName == "a" || clickedElement.TagName == "A")
            {
                link = clickedElement.GetAttribute("href");
            }
            else if (clickedElement.Parent != null)
            {
                if (clickedElement.Parent.TagName == "a" || clickedElement.Parent.TagName == "A")
                {
                    link = clickedElement.Parent.GetAttribute("href");
                }
            }

            if (link != null && link != "")
            {
                try
                {
                    System.Diagnostics.Process.Start(link);
                }
                catch
                {
                }
            }
        }
    }
}
