﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using lib2ch.IO;
using lib2ch.Data;

namespace lib2ch.Model
{
    public class Subject
    {
        string _Path = "./Log";
        string _FileName = "/subject.txt";
        List<SubjectList> _SubjectList;
        FileManager _File;
        public Subject()
        {
            _SubjectList = new List<SubjectList>();
            _File = new FileManager();
        }
        public SubjectList Get(BbsMenuItem BbsMenuItem)
        {
            int ret = Find(BbsMenuItem);
            if (ret != -1) return _SubjectList[ret];
            SubjectList SubjectList = new SubjectList();
            SubjectList.Name = BbsMenuItem.Name;
            SubjectList.Url = BbsMenuItem.Url;
            SubjectList.ParentName = BbsMenuItem.ParentName;
            FileResult fileResult = _File.StandardCheck(_Path + SubjectList.Directory,
                SubjectList.Url, _FileName);
            if (fileResult == null) return null;
            SubjectList.Parsing(fileResult.Line);
            SubjectList.ETag = fileResult.EntityTag;
            _SubjectList.Add(SubjectList);
            return SubjectList;
        }
        public SubjectList ReLoad(SubjectList SubjectList)
        {
            FileResult fileResult = _File.ModifieCheck(_Path + SubjectList.Directory,
                SubjectList.Url, _FileName, SubjectList.ETag);
            if (fileResult == null) return null;
            if (fileResult.Line.Count == 0) return null;
            SubjectList.Clear();
            SubjectList.Parsing(fileResult.Line);
            SubjectList.ETag = fileResult.EntityTag;
            return SubjectList;
        }
        private int Find(BbsMenuItem BbsMenuItem)
        {
            int index = 0;
            foreach (SubjectList SubjectList in _SubjectList)
            {
                if (BbsMenuItem.Name == SubjectList.Name)
                {
                    return index;
                }
                index++;
            }
            return -1;
        }
    }
}