﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing;

namespace cs2ch
{
    class FlowLayoutPanelEx : FlowLayoutPanel
    {
        Size _buttonSize;
        int _buttonCount;
        public FlowLayoutPanelEx()
        {
            _buttonSize = new Size(100, 20);
            _buttonCount = 1;
            this.Dock = DockStyle.None;
            this.SizeChanged += new EventHandler(this_SizeChanged);
        }
        void this_SizeChanged(object sender, EventArgs e)
        {
            this_DockChanger();
        }
        private void this_DockChanger()
        {
            if (this.Dock == DockStyle.Top ||
                 this.Dock == DockStyle.Bottom)
            {
                this.Size = new Size(this.Width, this.Height);
                this.AutoSize = true;
            }
            else
            {
                this.Size = new Size(_buttonSize.Width * _buttonCount, this.Height);
                this.AutoSize = false;
            }
        }
        public int ButtonCount
        {
            set { _buttonCount = value; }
        }
        public Size ButtonSize
        {
            set { _buttonSize = value; }
        }
    }
}
