package yukihane.inqubus.manager;

import saccubus.worker.profile.ConvertProfile;
import saccubus.worker.profile.DownloadProfile;

/**
 *
 * @author yuki
 */
public class RequestProcess implements Request {

    private static int serialId;
    private final int rowId;
    private final DownloadProfile downloadProfile;
    private final String videoId;
    private final ConvertProfile convertProfile;

    public RequestProcess(DownloadProfile download, String videoId, ConvertProfile convert) {
        this.rowId = ++serialId;
        this.downloadProfile = download;
        this.videoId = videoId;
        this.convertProfile = convert;
    }

    public ConvertProfile getConvertProfile() {
        return convertProfile;
    }

    public DownloadProfile getDownloadProfile() {
        return downloadProfile;
    }

    public String getVideoId() {
        return videoId;
    }

    @Override
    public int getRowId() {
        return rowId;
    }
}
