package yukihane.inqubus.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle.ComponentPlacement;
import org.apache.commons.lang.StringUtils;
import saccubus.FFmpegSelectedItem;
import saccubus.OptionComboBoxModel;
import yukihane.inqubus.config.Config;

/**
 *
 * @author yuki
 */
class FfmpegParamPanel extends JPanel {

    private static final long serialVersionUID = 1L;
    // ffmpeg - ffmpegパラメータ
    final OptionComboBoxModel mdlFfmpegOption = new OptionComboBoxModel();
    final JComboBox<FFmpegSelectedItem> cmbFfmpegOptionFile = new JComboBox<>(mdlFfmpegOption);
    final JTextField fldFfmpegOptionExtension = new JTextField();
    final JTextField fldFfmpegOptionMain = new JTextField();
    final JTextField fldFfmpegOptionIn = new JTextField();
    final JTextField fldFfmpegOptionOut = new JTextField();
    final JTextField fldFfmpegOptionAv = new JTextField();
    final JCheckBox cbFfmpegOptionResize = new JCheckBox("次のサイズに収まるよう縮小(-s)");
    final NumberFormattedTextField fldFfmpegOptionResizeWidth = new NumberFormattedTextField();
    final NumberFormattedTextField fldFfmpegOptionResizeHeight = new NumberFormattedTextField();
    final JCheckBox cbFfmpegOptionKeepAspect = new JCheckBox("アスペクト比を維持");

    void init(Config p) {
        final String fof = p.getFfmpegOptionFile();
        mdlFfmpegOption.reload(StringUtils.isNotEmpty(fof) ? new File(fof) : null);
        fldFfmpegOptionExtension.setText(p.getFfmpegExtension());
        fldFfmpegOptionMain.setText(p.getFfmpegMainOption());
        fldFfmpegOptionIn.setText(p.getFfmpegInOption());
        fldFfmpegOptionOut.setText(p.getFfmpegOutOption());
        fldFfmpegOptionAv.setText(p.getFfmpegAvOption());
        cbFfmpegOptionResize.setSelected(p.getFfmpegResizeEnable());
        fldFfmpegOptionResizeWidth.setText(p.getFfmpegResizeWidth());
        fldFfmpegOptionResizeHeight.setText(p.getFfmpegResizeHeight());
        cbFfmpegOptionKeepAspect.setSelected(p.getFfmpegKeepAspect());
    }

    FfmpegParamPanel() {
        final JLabel lblFfmpegOptionExtension = new JLabel("出力動画の拡張子");
        final JLabel lblFfmpegOptionMain = new JLabel("メインオプション");
        final JLabel lblFfmpegOptionIn = new JLabel("入力オプション");
        final JLabel lblFfmpegOptionOut = new JLabel("出力オプション");
        final JLabel lblFfmpegOptionAvfilter = new JLabel("avfilterオプション");
        final JLabel lblFfmpegOptionResizeWidth = new JLabel("横");
        final JLabel lblFfmpegOptionResizeHeight = new JLabel("縦");



        final JPanel pnlFfmpegParamOption = new JPanel();
        pnlFfmpegParamOption.setBorder(BorderFactory.createEtchedBorder());

        final GroupLayout glFfmpegParamOption = new GroupLayout(pnlFfmpegParamOption);
        glFfmpegParamOption.setAutoCreateContainerGaps(true);
        pnlFfmpegParamOption.setLayout(glFfmpegParamOption);
        glFfmpegParamOption.setHorizontalGroup(glFfmpegParamOption.createParallelGroup(Alignment.LEADING)
            .addGroup(glFfmpegParamOption.createSequentialGroup()
                .addGroup(glFfmpegParamOption.createParallelGroup(Alignment.LEADING)
                    .addComponent(lblFfmpegOptionAvfilter)
                    .addComponent(lblFfmpegOptionExtension)
                    .addComponent(lblFfmpegOptionMain)
                    .addComponent(lblFfmpegOptionIn)
                    .addComponent(lblFfmpegOptionOut)
                )
                .addPreferredGap(ComponentPlacement.RELATED)
                .addGroup(glFfmpegParamOption.createParallelGroup(Alignment.LEADING)
                    .addComponent(fldFfmpegOptionExtension, GroupLayout.PREFERRED_SIZE, 51, GroupLayout.PREFERRED_SIZE)
                    .addComponent(fldFfmpegOptionMain, GroupLayout.DEFAULT_SIZE, 268, Short.MAX_VALUE)
                    .addComponent(fldFfmpegOptionIn, GroupLayout.DEFAULT_SIZE, 268, Short.MAX_VALUE)
                    .addComponent(fldFfmpegOptionOut, GroupLayout.DEFAULT_SIZE, 268, Short.MAX_VALUE)
                    .addComponent(fldFfmpegOptionAv, GroupLayout.DEFAULT_SIZE, 268, Short.MAX_VALUE)
                )
            )
            .addGroup(glFfmpegParamOption.createSequentialGroup()
                .addComponent(cbFfmpegOptionResize)
                .addPreferredGap(ComponentPlacement.UNRELATED)
                .addComponent(lblFfmpegOptionResizeWidth)
                .addPreferredGap(ComponentPlacement.RELATED)
                .addComponent(fldFfmpegOptionResizeWidth, GroupLayout.PREFERRED_SIZE, 48, GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(ComponentPlacement.UNRELATED)
                .addComponent(lblFfmpegOptionResizeHeight)
                .addPreferredGap(ComponentPlacement.RELATED)
                .addComponent(fldFfmpegOptionResizeHeight, GroupLayout.PREFERRED_SIZE, 48, GroupLayout.PREFERRED_SIZE))
            .addGroup(glFfmpegParamOption.createSequentialGroup()
                .addGap(15)
                .addComponent(cbFfmpegOptionKeepAspect)
            )
        );

        glFfmpegParamOption.setVerticalGroup(glFfmpegParamOption.createSequentialGroup()
            .addGroup(glFfmpegParamOption.createParallelGroup(Alignment.BASELINE)
                .addComponent(lblFfmpegOptionExtension)
                .addComponent(fldFfmpegOptionExtension, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
            .addGroup(glFfmpegParamOption.createParallelGroup(Alignment.BASELINE)
                .addComponent(lblFfmpegOptionMain)
                .addComponent(fldFfmpegOptionMain, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
            .addGroup(glFfmpegParamOption.createParallelGroup(Alignment.BASELINE)
                .addComponent(lblFfmpegOptionIn)
                .addComponent(fldFfmpegOptionIn, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
            .addGroup(glFfmpegParamOption.createParallelGroup(Alignment.BASELINE)
                .addComponent(lblFfmpegOptionOut)
                .addComponent(fldFfmpegOptionOut, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
            .addGroup(glFfmpegParamOption.createParallelGroup(Alignment.BASELINE)
                .addComponent(lblFfmpegOptionAvfilter)
                .addComponent(fldFfmpegOptionAv, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
            .addGroup(glFfmpegParamOption.createParallelGroup(Alignment.BASELINE)
                .addComponent(cbFfmpegOptionResize)
                .addComponent(lblFfmpegOptionResizeWidth)
                .addComponent(fldFfmpegOptionResizeWidth, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                .addComponent(lblFfmpegOptionResizeHeight)
                .addComponent(fldFfmpegOptionResizeHeight, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
            .addComponent(cbFfmpegOptionKeepAspect)
        );

        final JButton btnReload = new JButton("更新");
        btnReload.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                mdlFfmpegOption.reload();
            }
        });


        final GroupLayout glFfmpegParam = new GroupLayout(this);
        setLayout(glFfmpegParam);
        glFfmpegParam.setHorizontalGroup(
            glFfmpegParam.createParallelGroup(Alignment.LEADING)
            .addGroup(glFfmpegParam.createSequentialGroup()
                .addContainerGap()
                .addGroup(glFfmpegParam.createParallelGroup(Alignment.LEADING)
                    .addGroup(glFfmpegParam.createSequentialGroup()
                        .addComponent(cmbFfmpegOptionFile, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(ComponentPlacement.UNRELATED)
                        .addComponent(btnReload)
                    )
                    .addComponent(pnlFfmpegParamOption, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                )
                .addContainerGap())
        );
        glFfmpegParam.setVerticalGroup(
            glFfmpegParam.createParallelGroup(Alignment.LEADING)
            .addGroup(glFfmpegParam.createSequentialGroup()
                .addContainerGap()
                .addGroup(glFfmpegParam.createParallelGroup(Alignment.BASELINE)
                    .addComponent(cmbFfmpegOptionFile, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnReload)
                )
                .addPreferredGap(ComponentPlacement.RELATED)
                .addComponent(pnlFfmpegParamOption)
                .addContainerGap())
        );
    }
}
