package yukihane.inqubus.config;

import saccubus.worker.profile.CommentProfile;
import saccubus.worker.profile.DownloadProfile;
import saccubus.worker.profile.GeneralProfile;
import saccubus.worker.profile.LoginProfile;
import saccubus.worker.profile.ProxyProfile;
import saccubus.worker.profile.VideoProfile;

/**
 * コンフィグに設定された値を基にしたDownloadProfile実装.
 * @author yuki
 */
public class ConfigDownloadProfile implements DownloadProfile {

    private final LoginProfile loginProfile;
    private final ProxyProfile proxyProfile;
    private final VideoProfile videoProfile;
    private final CommentProfile commentProfile;
    private final GeneralProfile generalProfile;

    public ConfigDownloadProfile() {
        this.loginProfile = new ConfigLoginProfile();
        this.proxyProfile = new ConfigProxyProfile();
        this.videoProfile = new ConfigVideoProfile();
        this.commentProfile = new ConfigCommentProfile();
        this.generalProfile = new ConfigGeneralProfile();
    }

    @Override
    public LoginProfile getLoginProfile() {
        return loginProfile;
    }

    @Override
    public ProxyProfile getProxyProfile() {
        return this.proxyProfile;
    }

    @Override
    public VideoProfile getVideoProfile() {
        return this.videoProfile;
    }

    @Override
    public CommentProfile getCommentProfile() {
        return this.commentProfile;
    }

    @Override
    public GeneralProfile getGeneralProfile() {
        return this.generalProfile;
    }
}
