#ifndef MAIN_H_
#define MAIN_H_
#include <SDL/SDL.h>
#include <SDL/SDL_ttf.h>
#include "nicodef.h"
#include "struct_define.h"
#include "chat/chat.h"
#include "chat/chat_slot.h"

/**
 * コメント中間ファイル数. つまりオーバレイするコメントの種類数.
 */
#define N_COMMENT_TYPE 4

/**
 * コメントの種類. 並びはframehook.hで定義している情報と関連があることに注意.
 */
typedef enum {
    COMMENT_USER_OPT, COMMENT_OWNER_OPT, COMMENT_USER, COMMENT_OWNER
} COMMENT_TYPE;

typedef enum {
    OPAQUE_FALSE, OPAQUE_TRUE, OPAQUE_HALF
} OPAQUE;

struct COMMDATA {
    int enable;
    CHAT chat;
    CHAT_SLOT slot;
    OPAQUE opaque_comment;
    DATA* common;
};

struct DATA{
	FILE* log;
	TTF_Font* font[CMD_FONT_MAX];
	SDL_Surface* screen;
//	/*それぞれのコメントに応じたデータ*/
//	//ユーザコメント
//	int enable_user_comment;
//	CHAT chat;
//	CHAT_SLOT slot;
//	//投稿者コメント
//	int enable_owner_comment;
    COMMDATA comment[N_COMMENT_TYPE];

	//一般的なデータ
	int shadow_kind;
	int show_video;
	int fontsize_fix;
	int process_first_called;
	int video_length;
    int aspect_mode;
};

typedef struct {
    const char* path;
    int enable;
} SETTING_COMMENT;

typedef struct SETTING{
    SETTING_COMMENT comment[N_COMMENT_TYPE];
	const char* font_path;
	int video_length;
	int font_index;
	int user_slot_max;
	int shadow_kind;
	/*TRUE OR FALSE*/
	int show_video;
	int fontsize_fix;
	OPAQUE opaque_comment;
    /**
     * アスペクト比の指定. コメントのフォントサイズや速度に影響する.
     * 0 - 4:3
     * 1 - 16:9
     */
    int aspect_mode;
}SETTING;

int init(FILE* log);
int initData(DATA* data,FILE* log,const SETTING* setting);
int main_process(DATA* data,SDL_Surface* surf,const int now_vpos);
int closeData(DATA* data);
int close();

#endif /*MAIN_H_*/
